/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.aeprocessor.aetree.relation;

import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.dsi.dataengine.utilities.ParameterType;
import com.amazon.sqlengine.aeprocessor.aetree.IAENode;
import com.amazon.sqlengine.aeprocessor.aetree.IAENodeVisitor;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AERelationalExpr;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEParameter;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEValueExpr;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEValueExprList;
import com.amazon.sqlengine.dsiext.dataengine.ProcedureParameterMetadata;
import com.amazon.sqlengine.dsiext.dataengine.StoredProcedure;
import com.amazon.sqlengine.exceptions.SQLEngineException;
import com.amazon.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.amazon.sqlengine.utilities.SQLEngineMessageKey;
import com.amazon.support.exceptions.DiagState;
import com.amazon.support.exceptions.ErrorException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class AEProcedure
extends AERelationalExpr {
    private AEValueExprList m_arguments;
    private final StoredProcedure m_procedure;
    private List<ProcedureParameterMetadata> m_expectedArgMeta;
    private List<ProcedureParameterMetadata> m_expectedDynamicParamMeta;
    private boolean m_callHasReturnValue;

    public AEProcedure(StoredProcedure storedProcedure, AEValueExprList aEValueExprList, boolean bl) throws ErrorException {
        this.m_procedure = storedProcedure;
        assert (null != aEValueExprList);
        this.m_arguments = aEValueExprList;
        this.m_arguments.setParent(this);
        this.m_callHasReturnValue = bl;
        this.initializeExpectedArgMetadata();
        this.validate();
    }

    private AEProcedure(AEProcedure aEProcedure) {
        super(aEProcedure);
        this.m_procedure = aEProcedure.m_procedure;
        this.m_arguments = new AEValueExprList(aEProcedure.m_arguments.copy());
        this.m_expectedArgMeta = new ArrayList<ProcedureParameterMetadata>(aEProcedure.m_expectedArgMeta);
        this.m_expectedDynamicParamMeta = new ArrayList<ProcedureParameterMetadata>(aEProcedure.m_expectedDynamicParamMeta);
        this.m_callHasReturnValue = aEProcedure.m_callHasReturnValue;
    }

    public List<ProcedureParameterMetadata> getAllExpectedProcParamMeta() {
        return this.m_expectedArgMeta;
    }

    public List<ProcedureParameterMetadata> getExpectedDynamicParamMeta() {
        return this.m_expectedDynamicParamMeta;
    }

    public StoredProcedure getProcedure() throws ErrorException {
        if (null == this.m_procedure) {
            throw SQLEngineExceptionFactory.invalidOperationException("GetProcedure");
        }
        return this.m_procedure;
    }

    public boolean hasArguments() {
        return 0 < this.m_arguments.getNumChildren();
    }

    public AEValueExprList getArguments() throws ErrorException {
        if (null == this.m_arguments) {
            throw SQLEngineExceptionFactory.invalidOperationException("GetArguments: Arguments have not been initialized");
        }
        return this.m_arguments;
    }

    public IAENode getChild(int n) {
        if (0 == n) {
            return this.m_arguments;
        }
        throw new IndexOutOfBoundsException();
    }

    public boolean callHasReturnValue() {
        return this.m_callHasReturnValue;
    }

    @Override
    public <T> T acceptVisitor(IAENodeVisitor<T> iAENodeVisitor) throws ErrorException {
        return iAENodeVisitor.visit(this);
    }

    @Override
    public Iterator<? extends IAENode> getChildItr() {
        return new AbstractList<IAENode>(){

            @Override
            public IAENode get(int n) {
                if (0 == n) {
                    return AEProcedure.this.m_arguments;
                }
                throw new IndexOutOfBoundsException("Illegal index: " + n);
            }

            @Override
            public int size() {
                return AEProcedure.this.getNumChildren();
            }
        }.iterator();
    }

    @Override
    public int getNumChildren() {
        return 1;
    }

    @Override
    public boolean isEquivalent(IAENode iAENode) {
        if (this == iAENode) {
            return true;
        }
        if (!(iAENode instanceof AEProcedure)) {
            return false;
        }
        AEProcedure aEProcedure = (AEProcedure)iAENode;
        return this.m_arguments.isEquivalent(aEProcedure.m_arguments) && this.m_procedure.getProcedureName().equalsIgnoreCase(aEProcedure.m_procedure.getProcedureName()) && this.m_procedure.getCatalogName().equalsIgnoreCase(aEProcedure.m_procedure.getCatalogName()) && this.m_procedure.getSchemaName().equalsIgnoreCase(aEProcedure.m_procedure.getSchemaName());
    }

    @Override
    public AEProcedure copy() {
        return new AEProcedure(this);
    }

    @Override
    public IColumn getColumn(int n) {
        return this.m_procedure.getCurrentResultMetadata().get(n);
    }

    @Override
    public int getColumnCount() {
        return this.m_procedure.getCurrentResultMetadata().size();
    }

    @Override
    public boolean getDataNeeded(int n) {
        return true;
    }

    @Override
    public int setDataNeeded(AERelationalExpr aERelationalExpr, int n) throws ErrorException {
        return n;
    }

    @Override
    public void setDataNeededOnChild() throws ErrorException {
    }

    @Override
    public String getLogString() {
        return "AEProcedure: " + this.m_procedure.getCatalogName() + "." + this.m_procedure.getSchemaName() + "." + this.m_procedure.getProcedureName();
    }

    public void validate() throws ErrorException {
        if (this.hasArguments() && this.m_expectedArgMeta.size() != this.m_arguments.getNumChildren()) {
            String[] stringArray = new String[]{this.m_procedure.getProcedureName(), Integer.toString(this.m_arguments.getNumChildren()), Integer.toString(this.m_expectedArgMeta.size())};
            throw new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.CORR_SPEC_INVALID_NUM_COLS.name(), stringArray);
        }
        int n = 0;
        if (this.m_callHasReturnValue && !this.m_procedure.hasReturnValue()) {
            throw SQLEngineExceptionFactory.unsupportedTypesException("Return Value");
        }
        if (!this.m_callHasReturnValue && this.m_procedure.hasReturnValue()) {
            n = -1;
        }
        ArrayList arrayList = (ArrayList)this.m_procedure.getParameters();
        for (int i = 0; i < arrayList.size(); ++i) {
            AEValueExpr aEValueExpr;
            ParameterType parameterType = ((ProcedureParameterMetadata)arrayList.get(i)).getParameterType();
            if (ParameterType.RETURN_VALUE == parameterType && !this.m_callHasReturnValue || (aEValueExpr = (AEValueExpr)this.m_arguments.getChild(i + n)) instanceof AEParameter) continue;
            if (ParameterType.OUTPUT == parameterType) {
                throw SQLEngineExceptionFactory.unsupportedTypesException("Output");
            }
            if (ParameterType.RETURN_VALUE != parameterType) continue;
            throw SQLEngineExceptionFactory.unsupportedTypesException("Return Value");
        }
    }

    public void initializeExpectedArgMetadata() throws ErrorException {
        this.m_expectedArgMeta = new ArrayList<ProcedureParameterMetadata>();
        this.m_expectedDynamicParamMeta = new ArrayList<ProcedureParameterMetadata>();
        ArrayList arrayList = (ArrayList)this.m_procedure.getParameters();
        int n = 0;
        if (!this.m_callHasReturnValue && this.getProcedure().hasReturnValue()) {
            n = 1;
        }
        for (int i = n; i < arrayList.size(); ++i) {
            ProcedureParameterMetadata procedureParameterMetadata = (ProcedureParameterMetadata)arrayList.get(i);
            ParameterType parameterType = procedureParameterMetadata.getParameterType();
            int n2 = procedureParameterMetadata.getParameterNumber() - n;
            if (procedureParameterMetadata.hasDefaultValue()) {
                if (ParameterType.OUTPUT == parameterType) {
                    throw SQLEngineExceptionFactory.invalidTypeParameterException("Output at index " + n2);
                }
                if (ParameterType.RETURN_VALUE == parameterType) {
                    throw SQLEngineExceptionFactory.invalidTypeParameterException("Return Value at index " + n2);
                }
            }
            if (ParameterType.RETURN_VALUE == parameterType && 0 != n2) {
                throw SQLEngineExceptionFactory.invalidTypeParameterException("Return Value at index " + n2);
            }
            if (arrayList.size() <= n2) {
                throw SQLEngineExceptionFactory.invalidCustomScalarFnMetadataException("Wrong number of parameters");
            }
            this.m_expectedArgMeta.add(n2, procedureParameterMetadata);
            if (!(this.m_arguments.getChild(i - n) instanceof AEParameter)) continue;
            this.m_expectedDynamicParamMeta.add(procedureParameterMetadata);
        }
        if (this.m_expectedArgMeta.size() != arrayList.size() - n) {
            throw SQLEngineExceptionFactory.invalidParseTreeException();
        }
    }
}

