/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.license;

import com.simba.athena.license.BasicValidationProvider;
import com.simba.athena.license.interfaces.IProductInfo;
import com.simba.athena.license.interfaces.IValidationInfoProvider;
import com.simba.athena.license.interfaces.IValidator;
import com.simba.athena.license.interfaces.SimbaLicenseException;
import com.simba.athena.license.interfaces.ValidatorsEnum;
import com.simba.athena.license.validators.ExpiryDateValidator;
import com.simba.athena.license.validators.ProductNameValidator;
import com.simba.athena.license.validators.ProductPlatfromValidator;
import com.simba.athena.license.validators.ProductVersionValidator;
import com.simba.athena.license.validators.SignatureValidator;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LicenseUtil {
    private IValidationInfoProvider mValidationProvider;
    private IValidator[] mValidators = new IValidator[64];

    public LicenseUtil(IProductInfo iProductInfo, String string) throws SimbaLicenseException {
        this.mValidationProvider = new BasicValidationProvider(iProductInfo, string);
        this.initializeValidators();
    }

    public boolean validate(ArrayList<String> arrayList) {
        byte[] byArray = this.mValidationProvider.getLicenseInfo().getBitMask();
        IValidator iValidator = null;
        iValidator = this.mValidators[ValidatorsEnum.SIGNATURE.bitNumber()] != null ? this.mValidators[ValidatorsEnum.SIGNATURE.bitNumber()] : new SignatureValidator();
        boolean bl = iValidator.validate(this.mValidationProvider, arrayList);
        if (!bl) {
            return false;
        }
        for (int i = 1; i < 64; ++i) {
            if (!this.isBitSet(byArray, i)) continue;
            if (this.mValidators[i] == null) {
                String string = String.format("Validator is not defined for bit %i", i);
                arrayList.add(string);
                continue;
            }
            bl = this.mValidators[i].validate(this.mValidationProvider, arrayList);
            if (bl) continue;
            return false;
        }
        return true;
    }

    private boolean isBitSet(byte[] byArray, int n) {
        if (n <= 64) {
            return 0 != (byArray[n / 8] & 1 << 7 - n % 8);
        }
        return false;
    }

    private void initializeValidators() {
        this.mValidators[ValidatorsEnum.SIGNATURE.bitNumber()] = new SignatureValidator();
        this.mValidators[ValidatorsEnum.EXPIRY.bitNumber()] = new ExpiryDateValidator();
        this.mValidators[ValidatorsEnum.PRODUCT_NAME.bitNumber()] = new ProductNameValidator();
        this.mValidators[ValidatorsEnum.PRODUCT_VERSION.bitNumber()] = new ProductVersionValidator();
        this.mValidators[ValidatorsEnum.PRODUCT_PLATFORM.bitNumber()] = new ProductPlatfromValidator();
    }
}

