/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.dsi.core.impl;

import com.simba.athena.dsi.core.impl.DSIDriver;
import com.simba.athena.dsi.core.interfaces.IConnection;
import com.simba.athena.dsi.core.interfaces.IStatement;
import com.simba.athena.dsi.core.utilities.AttributeDataMap;
import com.simba.athena.dsi.core.utilities.PropertyLimitKeys;
import com.simba.athena.dsi.core.utilities.Variant;
import com.simba.athena.dsi.exceptions.BadAttrValException;
import com.simba.athena.dsi.exceptions.BadPropertyKeyException;
import com.simba.athena.dsi.exceptions.IncorrectTypeException;
import com.simba.athena.dsi.exceptions.NumericOverflowException;
import com.simba.athena.dsi.utilities.DSIMessageKey;
import com.simba.athena.support.ILogger;
import com.simba.athena.support.IWarningListener;
import com.simba.athena.support.LogUtilities;
import com.simba.athena.support.Warning;
import com.simba.athena.support.WarningCode;
import com.simba.athena.support.exceptions.ErrorException;
import com.simba.athena.support.exceptions.ExceptionType;
import java.util.HashMap;
import java.util.Map;

public abstract class DSIStatement
implements IStatement {
    private final IConnection m_parentConnection;
    private final Map<Integer, PropertyLimitKeys> m_propertyLimitKeyMap = new HashMap<Integer, PropertyLimitKeys>();
    private final AttributeDataMap m_settings = new AttributeDataMap();
    private String m_cursorName = "";
    private IWarningListener m_warningListener = null;

    protected DSIStatement(IConnection iConnection) throws ErrorException {
        this.m_parentConnection = iConnection;
        try {
            this.loadProperties();
        }
        catch (NumericOverflowException numericOverflowException) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_NUMERIC_OVERFLOW.name(), ExceptionType.DEFAULT);
        }
        catch (IncorrectTypeException incorrectTypeException) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_VALTYPE_MISMATCH.name(), ExceptionType.DEFAULT);
        }
        this.loadPropertyKeyToPropertyLimitKeyMapping();
    }

    @Override
    public String getCursorName() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getLog(), new Object[0]);
        return this.m_cursorName;
    }

    @Override
    public Variant getCustomProperty(int n) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getLog(), n);
        return null;
    }

    @Override
    public int getCustomPropertyType(int n) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getLog(), n);
        return 0;
    }

    @Override
    public ILogger getLog() {
        return this.getParentConnection().getConnectionLog();
    }

    @Override
    public IConnection getParentConnection() {
        return this.m_parentConnection;
    }

    public AttributeDataMap getAllProperties() {
        return this.m_settings;
    }

    @Override
    public Variant getProperty(int n) throws BadPropertyKeyException, ErrorException {
        LogUtilities.logFunctionEntrance(this.getLog(), n);
        if (this.m_settings.isProperty(n)) {
            return this.m_settings.getProperty(n);
        }
        throw new BadPropertyKeyException(2, DSIMessageKey.INVALID_PROPKEY.name(), String.valueOf(n));
    }

    @Override
    public Variant getSimilarValue(int n, Variant variant) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getLog(), n, variant);
        try {
            PropertyLimitKeys propertyLimitKeys = this.m_propertyLimitKeyMap.get(n);
            if (null == propertyLimitKeys) {
                throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_PROP_LIMITKEY.name(), ExceptionType.DEFAULT);
            }
            int n2 = (int)variant.getLong();
            Integer n3 = propertyLimitKeys.getMaxLimitkey();
            Variant variant2 = this.m_settings.getProperty(n3);
            long l = n2;
            if (null != variant2) {
                l = variant2.getLong();
            }
            Integer n4 = propertyLimitKeys.getMinLimitkey();
            Variant variant3 = this.m_settings.getProperty(n4);
            long l2 = n2;
            if (null != variant3) {
                l2 = variant3.getLong();
            }
            if (null != variant2 && null != variant3 && l == l2) {
                return null;
            }
            if (null != variant2 && l < (long)n2) {
                return variant2;
            }
            if (null != variant3 && l2 > (long)n2) {
                return variant3;
            }
        }
        catch (IncorrectTypeException incorrectTypeException) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_VALTYPE_MISMATCH.name(), ExceptionType.DEFAULT);
        }
        catch (NumericOverflowException numericOverflowException) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_NUMERIC_OVERFLOW.name(), ExceptionType.DEFAULT);
        }
        return null;
    }

    @Override
    public IWarningListener getWarningListener() {
        return this.m_warningListener;
    }

    @Override
    public boolean isCustomProperty(int n) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getLog(), n);
        return false;
    }

    @Override
    public boolean isValueSupported(int n, Variant variant) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getLog(), n, variant);
        PropertyLimitKeys propertyLimitKeys = this.m_propertyLimitKeyMap.get(n);
        if (null == propertyLimitKeys) {
            return true;
        }
        try {
            long l = variant.getLong();
            boolean bl = false;
            Integer n2 = propertyLimitKeys.getMaxLimitkey();
            Variant variant2 = this.m_settings.getProperty(n2);
            long l2 = l;
            if (null != variant2) {
                l2 = variant2.getLong();
                bl = 0L != l2;
            }
            Integer n3 = propertyLimitKeys.getMinLimitkey();
            Variant variant3 = this.m_settings.getProperty(n3);
            long l3 = l;
            if (null != variant3) {
                l3 = variant3.getLong();
            }
            if (bl && null != variant3 && l2 == l3) {
                return l2 == l;
            }
            if (bl && l2 < l) {
                return false;
            }
            if (null != variant3 && l3 > l) {
                return false;
            }
        }
        catch (IncorrectTypeException incorrectTypeException) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_VALTYPE_MISMATCH.name(), ExceptionType.DEFAULT);
        }
        catch (NumericOverflowException numericOverflowException) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_NUMERIC_OVERFLOW.name(), ExceptionType.DEFAULT);
        }
        return true;
    }

    @Override
    public void notifyCursorNameChange(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getLog(), string);
        this.m_cursorName = string;
    }

    @Override
    public void registerWarningListener(IWarningListener iWarningListener) {
        LogUtilities.logFunctionEntrance(this.getLog(), iWarningListener);
        this.m_warningListener = iWarningListener;
    }

    @Override
    public void setCustomProperty(int n, Variant variant) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getLog(), n, variant);
    }

    @Override
    public void setProperty(int n, Variant variant) throws BadAttrValException, ErrorException {
        LogUtilities.logFunctionEntrance(this.getLog(), n, variant);
        if (this.isValueSupported(n, variant)) {
            this.m_settings.setProperty(n, variant);
        } else {
            Variant variant2 = this.getSimilarValue(n, variant);
            if (null == variant2) {
                throw new BadAttrValException(2, DSIMessageKey.BAD_ATTR_VAL.name(), new String[]{String.valueOf(n), variant.getString()});
            }
            this.m_settings.setProperty(n, variant2);
            if (null != this.m_warningListener) {
                this.m_warningListener.postWarning(new Warning(WarningCode.OPTIONAL_VALUE_CHANGED, 2, DSIMessageKey.OPTIONAL_VAL_CHANGED.name(), new String[]{String.valueOf(n), variant.getString()}));
            }
        }
    }

    private void loadProperties() throws IncorrectTypeException, NumericOverflowException {
        this.m_settings.setProperty(100, 4, 0xFFFFFFFFL);
        this.m_settings.setProperty(101, 4, 0L);
        this.m_settings.setProperty(102, 4, 0L);
        this.m_settings.setProperty(103, 4, 0L);
        this.m_settings.setProperty(104, 4, 0L);
        this.m_settings.setProperty(105, 4, 0L);
        this.m_settings.setProperty(106, 4, Integer.MAX_VALUE);
        this.m_settings.setProperty(107, 4, 0L);
        this.m_settings.setProperty(1, 4, 0L);
        this.m_settings.setProperty(2, 4, 0L);
        this.m_settings.setProperty(3, 4, 0L);
        this.m_settings.setProperty(4, 5, (short)0);
        this.m_settings.setProperty(5, 4, 1L);
        this.m_settings.setProperty(6, 4, 0L);
        this.m_settings.setProperty(108, 4, 0L);
    }

    private void loadPropertyKeyToPropertyLimitKeyMapping() {
        PropertyLimitKeys propertyLimitKeys = new PropertyLimitKeys(100, 101);
        this.m_propertyLimitKeyMap.put(1, propertyLimitKeys);
        PropertyLimitKeys propertyLimitKeys2 = new PropertyLimitKeys(102, 103);
        this.m_propertyLimitKeyMap.put(2, propertyLimitKeys2);
        PropertyLimitKeys propertyLimitKeys3 = new PropertyLimitKeys(104, 105);
        this.m_propertyLimitKeyMap.put(3, propertyLimitKeys3);
        PropertyLimitKeys propertyLimitKeys4 = new PropertyLimitKeys(106, 107);
        this.m_propertyLimitKeyMap.put(6, propertyLimitKeys4);
    }
}

