/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.http.timers.request;

import com.simba.athena.amazonaws.annotation.SdkInternalApi;
import com.simba.athena.amazonaws.annotation.SdkTestInternalApi;
import com.simba.athena.amazonaws.annotation.ThreadSafe;
import com.simba.athena.amazonaws.http.timers.TimeoutThreadPoolBuilder;
import com.simba.athena.amazonaws.http.timers.request.HttpRequestAbortTaskImpl;
import com.simba.athena.amazonaws.http.timers.request.HttpRequestAbortTaskTracker;
import com.simba.athena.amazonaws.http.timers.request.HttpRequestAbortTaskTrackerImpl;
import com.simba.athena.amazonaws.http.timers.request.NoOpHttpRequestAbortTaskTracker;
import com.simba.athena.shaded.apache.http.client.methods.HttpRequestBase;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@ThreadSafe
@SdkInternalApi
public class HttpRequestTimer {
    private static final String threadNamePrefix = "AwsSdkRequestTimerThread";
    private volatile ScheduledThreadPoolExecutor executor;

    public HttpRequestAbortTaskTracker startTimer(HttpRequestBase apacheRequest, int requestTimeoutMillis) {
        if (this.isTimeoutDisabled(requestTimeoutMillis)) {
            return NoOpHttpRequestAbortTaskTracker.INSTANCE;
        }
        if (this.executor == null) {
            this.initializeExecutor();
        }
        HttpRequestAbortTaskImpl timerTask = new HttpRequestAbortTaskImpl(apacheRequest);
        ScheduledFuture<?> timerTaskFuture = this.executor.schedule(timerTask, (long)requestTimeoutMillis, TimeUnit.MILLISECONDS);
        return new HttpRequestAbortTaskTrackerImpl(timerTask, timerTaskFuture);
    }

    private boolean isTimeoutDisabled(int requestTimeoutMillis) {
        return requestTimeoutMillis <= 0;
    }

    private synchronized void initializeExecutor() {
        if (this.executor == null) {
            this.executor = TimeoutThreadPoolBuilder.buildDefaultTimeoutThreadPool(threadNamePrefix);
        }
    }

    public synchronized void shutdown() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    @SdkTestInternalApi
    public ScheduledThreadPoolExecutor getExecutor() {
        return this.executor;
    }
}

