/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.wavelet.analysis;

import jj2000.j2k.wavelet.Subband;
import jj2000.j2k.wavelet.WaveletFilter;
import jj2000.j2k.wavelet.analysis.AnWTFilter;

public class SubbandAn
extends Subband {
    public SubbandAn parent = null;
    public SubbandAn subb_LL;
    public SubbandAn subb_HL;
    public SubbandAn subb_LH;
    public SubbandAn subb_HH;
    public AnWTFilter hFilter;
    public AnWTFilter vFilter;
    public float l2Norm = -1.0f;
    public float stepWMSE;

    public SubbandAn() {
    }

    public SubbandAn(int w, int h, int ulcx, int ulcy, int lvls, WaveletFilter[] hfilters, WaveletFilter[] vfilters) {
        super(w, h, ulcx, ulcy, lvls, hfilters, vfilters);
        this.calcL2Norms();
    }

    @Override
    public Subband getParent() {
        return this.parent;
    }

    @Override
    public Subband getLL() {
        return this.subb_LL;
    }

    @Override
    public Subband getHL() {
        return this.subb_HL;
    }

    @Override
    public Subband getLH() {
        return this.subb_LH;
    }

    @Override
    public Subband getHH() {
        return this.subb_HH;
    }

    @Override
    protected Subband split(WaveletFilter hfilter, WaveletFilter vfilter) {
        if (this.isNode) {
            throw new IllegalArgumentException();
        }
        this.isNode = true;
        this.hFilter = (AnWTFilter)hfilter;
        this.vFilter = (AnWTFilter)vfilter;
        this.subb_LL = new SubbandAn();
        this.subb_LH = new SubbandAn();
        this.subb_HL = new SubbandAn();
        this.subb_HH = new SubbandAn();
        this.subb_LL.parent = this;
        this.subb_HL.parent = this;
        this.subb_LH.parent = this;
        this.subb_HH.parent = this;
        this.initChilds();
        return this.subb_LL;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void calcBasisWaveForms(float[][] wfs) {
        if (!(this.l2Norm < 0.0f)) throw new Error("You have found a bug in JJ2000!");
        if (this.isNode) {
            if (this.subb_LL.l2Norm < 0.0f) {
                this.subb_LL.calcBasisWaveForms(wfs);
                wfs[0] = this.hFilter.getLPSynWaveForm(wfs[0], null);
                wfs[1] = this.vFilter.getLPSynWaveForm(wfs[1], null);
                return;
            } else if (this.subb_HL.l2Norm < 0.0f) {
                this.subb_HL.calcBasisWaveForms(wfs);
                wfs[0] = this.hFilter.getHPSynWaveForm(wfs[0], null);
                wfs[1] = this.vFilter.getLPSynWaveForm(wfs[1], null);
                return;
            } else if (this.subb_LH.l2Norm < 0.0f) {
                this.subb_LH.calcBasisWaveForms(wfs);
                wfs[0] = this.hFilter.getLPSynWaveForm(wfs[0], null);
                wfs[1] = this.vFilter.getHPSynWaveForm(wfs[1], null);
                return;
            } else {
                if (!(this.subb_HH.l2Norm < 0.0f)) throw new Error("You have found a bug in JJ2000!");
                this.subb_HH.calcBasisWaveForms(wfs);
                wfs[0] = this.hFilter.getHPSynWaveForm(wfs[0], null);
                wfs[1] = this.vFilter.getHPSynWaveForm(wfs[1], null);
            }
            return;
        } else {
            wfs[0] = new float[1];
            wfs[0][0] = 1.0f;
            wfs[1] = new float[1];
            wfs[1][0] = 1.0f;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void assignL2Norm(float l2n) {
        if (!(this.l2Norm < 0.0f)) throw new Error("You have found a bug in JJ2000!");
        if (this.isNode) {
            if (this.subb_LL.l2Norm < 0.0f) {
                this.subb_LL.assignL2Norm(l2n);
                return;
            } else if (this.subb_HL.l2Norm < 0.0f) {
                this.subb_HL.assignL2Norm(l2n);
                return;
            } else if (this.subb_LH.l2Norm < 0.0f) {
                this.subb_LH.assignL2Norm(l2n);
                return;
            } else {
                if (!(this.subb_HH.l2Norm < 0.0f)) throw new Error("You have found a bug in JJ2000!");
                this.subb_HH.assignL2Norm(l2n);
                if (!(this.subb_HH.l2Norm >= 0.0f)) return;
                this.l2Norm = 0.0f;
            }
            return;
        } else {
            this.l2Norm = l2n;
        }
    }

    private void calcL2Norms() {
        float[][] wfs = new float[2][];
        while (this.l2Norm < 0.0f) {
            int i;
            this.calcBasisWaveForms(wfs);
            double acc = 0.0;
            for (i = wfs[0].length - 1; i >= 0; --i) {
                acc += (double)(wfs[0][i] * wfs[0][i]);
            }
            float l2n = (float)Math.sqrt(acc);
            acc = 0.0;
            for (i = wfs[1].length - 1; i >= 0; --i) {
                acc += (double)(wfs[1][i] * wfs[1][i]);
            }
            wfs[0] = null;
            wfs[1] = null;
            this.assignL2Norm(l2n *= (float)Math.sqrt(acc));
        }
    }

    @Override
    public WaveletFilter getHorWFilter() {
        return this.hFilter;
    }

    @Override
    public WaveletFilter getVerWFilter() {
        return this.hFilter;
    }
}

