/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.Samples;
import blbutil.Const;
import vcf.GL;
import vcf.Marker;
import vcf.Markers;
import vcf.VcfEmission;

public final class BasicGL
implements GL {
    private final Samples samples;
    private final Markers markers;
    private final VcfEmission[] vma;
    private final boolean isRefData;

    public static int genotype(int n, int n2) {
        if (n <= n2) {
            if (n < 0) {
                String string = "allele < 0: " + n + " " + n2;
                throw new IllegalArgumentException(string);
            }
            return n2 * (n2 + 1) / 2 + n;
        }
        if (n2 < 0) {
            String string = "allele < 0: " + n + " " + n2;
            throw new IllegalArgumentException(string);
        }
        return n * (n + 1) / 2 + n2;
    }

    public BasicGL(Samples samples, VcfEmission[] vcfEmissionArray) {
        BasicGL.checkSamples(samples, vcfEmissionArray);
        this.markers = BasicGL.markers(vcfEmissionArray);
        this.samples = samples;
        this.vma = (VcfEmission[])vcfEmissionArray.clone();
        this.isRefData = BasicGL.isRefData(vcfEmissionArray);
    }

    private static void checkSamples(Samples samples, VcfEmission[] vcfEmissionArray) {
        for (int i = 0; i < vcfEmissionArray.length; ++i) {
            if (vcfEmissionArray[i].samples().equals(samples)) continue;
            throw new IllegalArgumentException("inconsistent samples");
        }
    }

    private static Markers markers(VcfEmission[] vcfEmissionArray) {
        Marker[] markerArray = new Marker[vcfEmissionArray.length];
        for (int i = 0; i < markerArray.length; ++i) {
            markerArray[i] = vcfEmissionArray[i].marker();
        }
        return Markers.create(markerArray);
    }

    private static boolean isRefData(VcfEmission[] vcfEmissionArray) {
        boolean bl = true;
        for (int i = 0; i < vcfEmissionArray.length && bl; ++i) {
            if (vcfEmissionArray[i].isRefData()) continue;
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean isRefData() {
        return this.isRefData;
    }

    @Override
    public float gl(int n, int n2, int n3, int n4) {
        return this.vma[n].gl(n2, n3, n4);
    }

    @Override
    public boolean isPhased(int n, int n2) {
        return this.vma[n].isPhased(n2);
    }

    @Override
    public int allele1(int n, int n2) {
        return this.vma[n].allele1(n2);
    }

    @Override
    public int allele2(int n, int n2) {
        return this.vma[n].allele2(n2);
    }

    @Override
    public int allele(int n, int n2) {
        return this.vma[n].allele(n2);
    }

    @Override
    public int nMarkers() {
        return this.vma.length;
    }

    @Override
    public Marker marker(int n) {
        return this.markers.marker(n);
    }

    @Override
    public Markers markers() {
        return this.markers;
    }

    @Override
    public int nHaps() {
        return 2 * this.samples.nSamples();
    }

    @Override
    public int nSamples() {
        return this.samples.nSamples();
    }

    @Override
    public Samples samples() {
        return this.samples;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[BasicGL: nMarkers=");
        stringBuilder.append(this.nMarkers());
        stringBuilder.append(" nSamples=");
        stringBuilder.append(this.nSamples());
        for (VcfEmission vcfEmission : this.vma) {
            stringBuilder.append(Const.nl);
            stringBuilder.append(vcfEmission);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

