# ifndef CPPAD_CORE_CONVERT_HPP
# define CPPAD_CORE_CONVERT_HPP
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-or-later
// SPDX-FileCopyrightText: Bradley M. Bell <bradbell@seanet.com>
// SPDX-FileContributor: 2003-22 Bradley M. Bell
// ----------------------------------------------------------------------------

/*
{xrst_begin Convert}

Conversion and I/O of AD Objects
################################
{xrst_toc_hidden
   include/cppad/core/value.hpp
   include/cppad/core/integer.hpp
   include/cppad/core/ad_to_string.hpp
   include/cppad/core/ad_io.hpp
   include/cppad/core/print_for.hpp
   include/cppad/core/var2par.hpp
}

.. csv-table::
   :widths: auto

   Value,:ref:`Value-title`
   Integer,:ref:`Integer-title`
   ad_output,:ref:`ad_output-title`
   PrintFor,:ref:`PrintFor-title`
   Var2Par,:ref:`Var2Par-title`

{xrst_end Convert}
*/

# include <cppad/core/value.hpp>
# include <cppad/core/integer.hpp>
# include <cppad/core/ad_to_string.hpp>
# include <cppad/core/ad_io.hpp>
# include <cppad/core/print_for.hpp>
# include <cppad/core/var2par.hpp>

# endif
