/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.vikamine.kernel.data.Attribute;
import org.vikamine.kernel.data.Ontology;
import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.SGFilters;
import org.vikamine.kernel.subgroup.SGSet;
import org.vikamine.kernel.subgroup.analysis.WeightedCoveringAnalyzer;
import org.vikamine.kernel.subgroup.search.AbstractMiningTask;
import org.vikamine.kernel.subgroup.search.SDMethod;
import org.vikamine.kernel.subgroup.selectors.SGSelector;
import org.vikamine.kernel.subgroup.target.SelectorTarget;

public class MiningTask
extends AbstractMiningTask
implements Cloneable {
    protected int maxSGDSize = Integer.MAX_VALUE;
    private SDMethod method;

    public MiningTask() {
    }

    public MiningTask(Ontology onto) {
        this.setOntology(onto);
    }

    public MiningTask(AbstractMiningTask oldTask) {
        this();
        this.setSearchSpace(new ArrayList<SGSelector>(oldTask.searchSpace));
        this.setTarget(oldTask.getTarget());
        this.setMethodType(oldTask.getMethodType());
        this.setQualityFunction(oldTask.getQualityFunction());
        this.setInitialSG(oldTask.getInitialSG());
        this.setOntology(oldTask.getOntology());
        this.setWeightedCovering(oldTask.isWeightedCovering());
        this.setMaxSGCount(oldTask.getMaxSGCount());
        this.setMinQualityLimit(oldTask.getMinQualityLimit());
        this.setMinSubgroupSize(oldTask.getMinSubgroupSize());
        this.setMinTPSupportAbsolute(oldTask.getMinTPSupportAbsolute());
        this.setMinTPSupportRelative(oldTask.getMinTPSupportRelative());
        this.setInvertQualityFunction(oldTask.isInvertQualityFunction());
        this.setSuppressStrictlyIrrelevantSubgroups(oldTask.isSuppressStrictlyIrrelevantSubgroups());
        this.setIgnoreDefaultValues(oldTask.isIgnoreDefaultValues());
        if (oldTask instanceof MiningTask) {
            this.setMaxSGDSize(((MiningTask)oldTask).getMaxSGDSize());
        }
    }

    public Object clone() throws CloneNotSupportedException {
        MiningTask aTask = new MiningTask(this);
        aTask.setMaxSGDSize(this.maxSGDSize);
        return aTask;
    }

    public int getMaxSGDSize() {
        return this.maxSGDSize;
    }

    public SGSet performSubgroupDiscovery() {
        return this.performSubgroupDiscovery(Collections.EMPTY_LIST);
    }

    public SGSet performSubgroupDiscovery(List<SGFilters> sgFilters) {
        if (this.initialSG == null) {
            this.initialSG = new SG(this.ontology.getDataView(), this.getTarget());
        }
        if (this.initialSG.getStatistics() == null) {
            this.initialSG.createStatistics();
        }
        int realMaxSGCount = this.getMaxSGCount();
        if (this.isWeightedCovering()) {
            this.setMaxSGCount((int)(Math.log(this.getMaxSGCount()) * (double)this.getMaxSGCount()));
        }
        this.method = this.getMethod();
        try {
            this.method.setTask((MiningTask)this.clone());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        SGSet result = this.method.perform(null);
        if (sgFilters != null && !sgFilters.isEmpty()) {
            for (SGFilters filter : sgFilters) {
                result = filter.filterSGs(result);
            }
        }
        if (this.isWeightedCovering()) {
            this.setMaxSGCount(realMaxSGCount);
        }
        if (this.weightedCovering && this.target.isBoolean() && result != null) {
            WeightedCoveringAnalyzer w = new WeightedCoveringAnalyzer();
            return w.getKBestCoveringSubgroups(this.maxSGCount, result, this.ontology.getDataView(), this.getQualityFunction());
        }
        return result;
    }

    public boolean fulfillsMinTPSupport(double tpCount) {
        return this.fulfillsMinTPSupport(tpCount, this.ontology.getDataView().size());
    }

    public boolean fulfillsMinTPSupport(double tpCount, double dataViewSize) {
        double minTPSupport = Math.max(this.minTPSupportAbsolute, this.minTPSupportRelative * dataViewSize);
        return tpCount >= minTPSupport;
    }

    public void setMaxSGDSize(int maxSGDSize) {
        this.maxSGDSize = maxSGDSize;
    }

    public void cancel() {
        if (this.method != null) {
            this.method.cancel();
        }
    }

    public void setMethod(SDMethod method) {
        this.method = method;
        this.methodType = method.getClass();
    }

    public SDMethod getMethod() {
        if (this.method == null) {
            this.createMethod(this.methodType);
        }
        return this.method;
    }

    public void recreateMethod() {
        this.createMethod(this.methodType);
    }

    public int generateID() {
        int prime = 31;
        int result = 1;
        String datasetName = this.getOntology().getDatasetName();
        result = 31 * result + datasetName.hashCode();
        String targetTypeStr = "unknown";
        if (this.getTarget().isNumeric()) {
            targetTypeStr = "numeric";
        }
        if (this.getTarget().isBoolean()) {
            targetTypeStr = "boolean";
        }
        result = 31 * result + targetTypeStr.hashCode();
        Collection<Attribute> targetAttributes = this.getTarget().getAttributes();
        String targetAttributesString = "";
        for (Attribute att : targetAttributes) {
            targetAttributesString = String.valueOf(targetAttributesString) + att.getDescription();
        }
        result = 31 * result + targetAttributesString.hashCode();
        String targetSelector = "none";
        if (this.getTarget() instanceof SelectorTarget) {
            SGSelector selector = ((SelectorTarget)this.getTarget()).getSelector();
            targetSelector = selector.getDescription();
        }
        result = 31 * result + targetSelector.hashCode();
        int searchSpaceSize = this.getSearchSpace().size();
        result = 31 * result + searchSpaceSize;
        String qFunction = this.getQualityFunction().getName();
        result = 31 * result + qFunction.hashCode();
        String method = this.getMethod().getName();
        result = 31 * result + method.hashCode();
        result = 31 * result + this.getMaxSGCount();
        result = 31 * result + Double.valueOf(this.getMinQualityLimit()).hashCode();
        result = 31 * result + Double.valueOf(this.getMaxSGDSize()).hashCode();
        result = 31 * result + Double.valueOf(this.getMinSubgroupSize()).hashCode();
        result = 31 * result + Double.valueOf(this.getMinSubgroupSize()).hashCode();
        result = 31 * result + Double.valueOf(this.getMinTPSupportRelative()).hashCode();
        result = 31 * result + Double.valueOf(this.getMinTPSupportAbsolute()).hashCode();
        return result;
    }

    private void createMethod(Class c) {
        try {
            this.method = (SDMethod)c.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Could not create SD-Algorithm!");
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Could not create SD-Algorithm!");
        }
    }
}

