/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta.nestedDichotomies;

import java.util.Hashtable;
import java.util.Random;
import weka.classifiers.Classifier;
import weka.classifiers.RandomizableSingleClassifierEnhancer;
import weka.classifiers.meta.FilteredClassifier;
import weka.classifiers.rules.ZeroR;
import weka.classifiers.trees.J48;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.MakeIndicator;
import weka.filters.unsupervised.instance.RemoveWithValues;

public class DataNearBalancedND
extends RandomizableSingleClassifierEnhancer
implements TechnicalInformationHandler {
    static final long serialVersionUID = 5117477294209496368L;
    protected FilteredClassifier m_FilteredClassifier;
    protected Hashtable m_classifiers = new Hashtable();
    protected DataNearBalancedND m_FirstSuccessor = null;
    protected DataNearBalancedND m_SecondSuccessor = null;
    protected Range m_Range = null;
    protected boolean m_hashtablegiven = false;

    public DataNearBalancedND() {
        this.m_Classifier = new J48();
    }

    @Override
    protected String defaultClassifierString() {
        return "weka.classifiers.trees.J48";
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Lin Dong and Eibe Frank and Stefan Kramer");
        result.setValue(TechnicalInformation.Field.TITLE, "Ensembles of Balanced Nested Dichotomies for Multi-class Problems");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "PKDD");
        result.setValue(TechnicalInformation.Field.YEAR, "2005");
        result.setValue(TechnicalInformation.Field.PAGES, "84-95");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "Springer");
        TechnicalInformation additional = result.add(TechnicalInformation.Type.INPROCEEDINGS);
        additional.setValue(TechnicalInformation.Field.AUTHOR, "Eibe Frank and Stefan Kramer");
        additional.setValue(TechnicalInformation.Field.TITLE, "Ensembles of nested dichotomies for multi-class problems");
        additional.setValue(TechnicalInformation.Field.BOOKTITLE, "Twenty-first International Conference on Machine Learning");
        additional.setValue(TechnicalInformation.Field.YEAR, "2004");
        additional.setValue(TechnicalInformation.Field.PUBLISHER, "ACM");
        return result;
    }

    public void setHashtable(Hashtable table) {
        this.m_hashtablegiven = true;
        this.m_classifiers = table;
    }

    private void generateClassifierForNode(Instances data, Range classes, Random rand, Classifier classifier, Hashtable table, double[] instsNumAllClasses) throws Exception {
        RemoveWithValues rwv;
        int[] indices = classes.getSelection();
        int j = indices.length - 1;
        while (j > 0) {
            int randPos = rand.nextInt(j + 1);
            int temp = indices[randPos];
            indices[randPos] = indices[j];
            indices[j] = temp;
            --j;
        }
        double total = 0.0;
        int j2 = 0;
        while (j2 < indices.length) {
            total += instsNumAllClasses[indices[j2]];
            ++j2;
        }
        double halfOfTotal = total / 2.0;
        double sumLeft = 0.0;
        double sumRight = 0.0;
        int i = 0;
        int j3 = indices.length - 1;
        do {
            if (i == j3) {
                if (rand.nextBoolean()) {
                    sumLeft += instsNumAllClasses[indices[i++]];
                    continue;
                }
                sumRight += instsNumAllClasses[indices[j3--]];
                continue;
            }
            sumLeft += instsNumAllClasses[indices[i++]];
            sumRight += instsNumAllClasses[indices[j3--]];
        } while (Utils.sm(sumLeft, halfOfTotal) && Utils.sm(sumRight, halfOfTotal));
        int first = 0;
        int second = 0;
        first = !Utils.sm(sumLeft, halfOfTotal) ? i : j3 + 1;
        second = indices.length - first;
        int[] firstInds = new int[first];
        int[] secondInds = new int[second];
        System.arraycopy(indices, 0, firstInds, 0, first);
        System.arraycopy(indices, first, secondInds, 0, second);
        int[] sortedFirst = Utils.sort(firstInds);
        int[] sortedSecond = Utils.sort(secondInds);
        int[] firstCopy = new int[first];
        int[] secondCopy = new int[second];
        int k = 0;
        while (k < sortedFirst.length) {
            firstCopy[k] = firstInds[sortedFirst[k]];
            ++k;
        }
        firstInds = firstCopy;
        k = 0;
        while (k < sortedSecond.length) {
            secondCopy[k] = secondInds[sortedSecond[k]];
            ++k;
        }
        secondInds = secondCopy;
        if (firstInds[0] > secondInds[0]) {
            int[] help = secondInds;
            secondInds = firstInds;
            firstInds = help;
            int help2 = second;
            second = first;
            first = help2;
        }
        this.m_Range = new Range(Range.indicesToRangeList(firstInds));
        this.m_Range.setUpper(data.numClasses() - 1);
        Range secondRange = new Range(Range.indicesToRangeList(secondInds));
        secondRange.setUpper(data.numClasses() - 1);
        MakeIndicator filter = new MakeIndicator();
        filter.setAttributeIndex("" + (data.classIndex() + 1));
        filter.setValueIndices(this.m_Range.getRanges());
        filter.setNumeric(false);
        filter.setInputFormat(data);
        this.m_FilteredClassifier = new FilteredClassifier();
        if (data.numInstances() > 0) {
            this.m_FilteredClassifier.setClassifier(Classifier.makeCopies(classifier, 1)[0]);
        } else {
            this.m_FilteredClassifier.setClassifier(new ZeroR());
        }
        this.m_FilteredClassifier.setFilter(filter);
        this.m_classifiers = table;
        if (!this.m_classifiers.containsKey(String.valueOf(this.getString(firstInds)) + "|" + this.getString(secondInds))) {
            this.m_FilteredClassifier.buildClassifier(data);
            this.m_classifiers.put(String.valueOf(this.getString(firstInds)) + "|" + this.getString(secondInds), this.m_FilteredClassifier);
        } else {
            this.m_FilteredClassifier = (FilteredClassifier)this.m_classifiers.get(String.valueOf(this.getString(firstInds)) + "|" + this.getString(secondInds));
        }
        this.m_FirstSuccessor = new DataNearBalancedND();
        if (first == 1) {
            this.m_FirstSuccessor.m_Range = this.m_Range;
        } else {
            rwv = new RemoveWithValues();
            rwv.setInvertSelection(true);
            rwv.setNominalIndices(this.m_Range.getRanges());
            rwv.setAttributeIndex("" + (data.classIndex() + 1));
            rwv.setInputFormat(data);
            Instances firstSubset = Filter.useFilter(data, rwv);
            this.m_FirstSuccessor.generateClassifierForNode(firstSubset, this.m_Range, rand, classifier, this.m_classifiers, instsNumAllClasses);
        }
        this.m_SecondSuccessor = new DataNearBalancedND();
        if (second == 1) {
            this.m_SecondSuccessor.m_Range = secondRange;
        } else {
            rwv = new RemoveWithValues();
            rwv.setInvertSelection(true);
            rwv.setNominalIndices(secondRange.getRanges());
            rwv.setAttributeIndex("" + (data.classIndex() + 1));
            rwv.setInputFormat(data);
            Instances secondSubset = Filter.useFilter(data, rwv);
            this.m_SecondSuccessor = new DataNearBalancedND();
            this.m_SecondSuccessor.generateClassifierForNode(secondSubset, secondRange, rand, classifier, this.m_classifiers, instsNumAllClasses);
        }
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAllClasses();
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.setMinimumNumberInstances(1);
        return result;
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        data = new Instances(data);
        data.deleteWithMissingClass();
        Random random = data.getRandomNumberGenerator(this.m_Seed);
        if (!this.m_hashtablegiven) {
            this.m_classifiers = new Hashtable();
        }
        boolean[] present = new boolean[data.numClasses()];
        int i = 0;
        while (i < data.numInstances()) {
            present[(int)data.instance((int)i).classValue()] = true;
            ++i;
        }
        StringBuffer list = new StringBuffer();
        int i2 = 0;
        while (i2 < present.length) {
            if (present[i2]) {
                if (list.length() > 0) {
                    list.append(",");
                }
                list.append(i2 + 1);
            }
            ++i2;
        }
        double[] instsNum = new double[data.numClasses()];
        int i3 = 0;
        while (i3 < data.numInstances()) {
            int n = (int)data.instance(i3).classValue();
            instsNum[n] = instsNum[n] + data.instance(i3).weight();
            ++i3;
        }
        Range newRange = new Range(list.toString());
        newRange.setUpper(data.numClasses() - 1);
        this.generateClassifierForNode(data, newRange, random, this.m_Classifier, this.m_classifiers, instsNum);
    }

    @Override
    public double[] distributionForInstance(Instance inst) throws Exception {
        double[] newDist = new double[inst.numClasses()];
        if (this.m_FirstSuccessor == null) {
            int i = 0;
            while (i < inst.numClasses()) {
                if (this.m_Range.isInRange(i)) {
                    newDist[i] = 1.0;
                }
                ++i;
            }
            return newDist;
        }
        double[] firstDist = this.m_FirstSuccessor.distributionForInstance(inst);
        double[] secondDist = this.m_SecondSuccessor.distributionForInstance(inst);
        double[] dist = this.m_FilteredClassifier.distributionForInstance(inst);
        int i = 0;
        while (i < inst.numClasses()) {
            if (firstDist[i] > 0.0 && secondDist[i] > 0.0) {
                System.err.println("Panik!!");
            }
            newDist[i] = this.m_Range.isInRange(i) ? dist[1] * firstDist[i] : dist[0] * secondDist[i];
            ++i;
        }
        if (!Utils.eq(Utils.sum(newDist), 1.0)) {
            System.err.println(Utils.sum(newDist));
            int j = 0;
            while (j < dist.length) {
                System.err.print(String.valueOf(dist[j]) + " ");
                ++j;
            }
            System.err.println();
            j = 0;
            while (j < newDist.length) {
                System.err.print(String.valueOf(newDist[j]) + " ");
                ++j;
            }
            System.err.println();
            System.err.println(inst);
            System.err.println(this.m_FilteredClassifier);
            System.err.println("bad");
        }
        return newDist;
    }

    public String getString(int[] indices) {
        StringBuffer string = new StringBuffer();
        int i = 0;
        while (i < indices.length) {
            if (i > 0) {
                string.append(',');
            }
            string.append(indices[i]);
            ++i;
        }
        return string.toString();
    }

    public String globalInfo() {
        return "A meta classifier for handling multi-class datasets with 2-class classifiers by building a random data-balanced tree structure.\n\nFor more info, check\n\n" + this.getTechnicalInformation().toString();
    }

    public String toString() {
        if (this.m_classifiers == null) {
            return "DataNearBalancedND: No model built yet.";
        }
        StringBuffer text = new StringBuffer();
        text.append("DataNearBalancedND");
        this.treeToString(text, 0);
        return text.toString();
    }

    private int treeToString(StringBuffer text, int nn) {
        text.append("\n\nNode number: " + ++nn + "\n\n");
        if (this.m_FilteredClassifier != null) {
            text.append(this.m_FilteredClassifier);
        } else {
            text.append("null");
        }
        if (this.m_FirstSuccessor != null) {
            nn = this.m_FirstSuccessor.treeToString(text, nn);
            nn = this.m_SecondSuccessor.treeToString(text, nn);
        }
        return nn;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.8 $");
    }

    public static void main(String[] argv) {
        DataNearBalancedND.runClassifier(new DataNearBalancedND(), argv);
    }
}

