/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
#ifndef H5Apublic_H
#define H5Apublic_H
#include "H5public.h"
#include "H5Ipublic.h"
#include "H5Opublic.h"
#include "H5Tpublic.h"
//! <!-- [H5A_info_t_snip] -->
typedef struct {
    hbool_t           corder_valid;
    H5O_msg_crt_idx_t corder;
    H5T_cset_t        cset;
    hsize_t           data_size;
} H5A_info_t;
//! <!-- [H5A_info_t_snip] -->
//! <!-- [H5A_operator2_t_snip] -->
typedef herr_t (*H5A_operator2_t)(hid_t location_id, const char *attr_name,
                                  const H5A_info_t *ainfo, void *op_data);
//! <!-- [H5A_operator2_t_snip] -->
#ifdef __cplusplus
extern "C" {
#endif
H5_DLL herr_t H5Aclose(hid_t attr_id);
#ifndef H5_DOXYGEN
H5_DLL herr_t H5Aclose_async(const char *app_file, const char *app_func, unsigned app_line, hid_t attr_id,
                             hid_t es_id);
#else
H5_DLL herr_t H5Aclose_async(hid_t attr_id, hid_t es_id);
#endif
H5_DLL hid_t H5Acreate2(hid_t loc_id, const char *attr_name, hid_t type_id, hid_t space_id, hid_t acpl_id,
                        hid_t aapl_id);
#ifndef H5_DOXYGEN
H5_DLL hid_t H5Acreate_async(const char *app_file, const char *app_func, unsigned app_line, hid_t loc_id,
                             const char *attr_name, hid_t type_id, hid_t space_id, hid_t acpl_id,
                             hid_t aapl_id, hid_t es_id);
#else
H5_DLL hid_t H5Acreate_async(hid_t loc_id, const char *attr_name, hid_t type_id, hid_t space_id,
                             hid_t acpl_id, hid_t aapl_id, hid_t es_id);
#endif
H5_DLL hid_t H5Acreate_by_name(hid_t loc_id, const char *obj_name, const char *attr_name, hid_t type_id,
                               hid_t space_id, hid_t acpl_id, hid_t aapl_id, hid_t lapl_id);
#ifndef H5_DOXYGEN
H5_DLL hid_t H5Acreate_by_name_async(const char *app_file, const char *app_func, unsigned app_line,
                                     hid_t loc_id, const char *obj_name, const char *attr_name, hid_t type_id,
                                     hid_t space_id, hid_t acpl_id, hid_t aapl_id, hid_t lapl_id,
                                     hid_t es_id);
#else
H5_DLL hid_t H5Acreate_by_name_async(hid_t loc_id, const char *obj_name, const char *attr_name, hid_t type_id,
                                     hid_t space_id, hid_t acpl_id, hid_t aapl_id, hid_t lapl_id,
                                     hid_t es_id);
#endif
H5_DLL herr_t H5Adelete(hid_t loc_id, const char *attr_name);
H5_DLL herr_t H5Adelete_by_idx(hid_t loc_id, const char *obj_name, H5_index_t idx_type, H5_iter_order_t order,
                               hsize_t n, hid_t lapl_id);
H5_DLL herr_t H5Adelete_by_name(hid_t loc_id, const char *obj_name, const char *attr_name, hid_t lapl_id);
H5_DLL htri_t H5Aexists(hid_t obj_id, const char *attr_name);
#ifndef H5_DOXYGEN
H5_DLL herr_t H5Aexists_async(const char *app_file, const char *app_func, unsigned app_line, hid_t obj_id,
                              const char *attr_name, hbool_t *exists, hid_t es_id);
#else
H5_DLL herr_t H5Aexists_async(hid_t obj_id, const char *attr_name, hbool_t *exists, hid_t es_id);
#endif
H5_DLL htri_t H5Aexists_by_name(hid_t obj_id, const char *obj_name, const char *attr_name, hid_t lapl_id);
#ifndef H5_DOXYGEN
H5_DLL herr_t H5Aexists_by_name_async(const char *app_file, const char *app_func, unsigned app_line,
                                      hid_t loc_id, const char *obj_name, const char *attr_name,
                                      hbool_t *exists, hid_t lapl_id, hid_t es_id);
#else
H5_DLL herr_t H5Aexists_by_name_async(hid_t loc_id, const char *obj_name, const char *attr_name,
                                      hbool_t *exists, hid_t lapl_id, hid_t es_id);
#endif
H5_DLL hid_t H5Aget_create_plist(hid_t attr_id);
H5_DLL herr_t H5Aget_info(hid_t attr_id, H5A_info_t *ainfo);
H5_DLL herr_t H5Aget_info_by_idx(hid_t loc_id, const char *obj_name, H5_index_t idx_type,
                                 H5_iter_order_t order, hsize_t n, H5A_info_t *ainfo, hid_t lapl_id);
H5_DLL herr_t H5Aget_info_by_name(hid_t loc_id, const char *obj_name, const char *attr_name,
                                  H5A_info_t *ainfo, hid_t lapl_id);
H5_DLL ssize_t H5Aget_name(hid_t attr_id, size_t buf_size, char *buf);
H5_DLL ssize_t H5Aget_name_by_idx(hid_t loc_id, const char *obj_name, H5_index_t idx_type,
                                  H5_iter_order_t order, hsize_t n, char *name, size_t size,
                                  hid_t lapl_id);
H5_DLL hid_t H5Aget_space(hid_t attr_id);
H5_DLL hsize_t H5Aget_storage_size(hid_t attr_id);
H5_DLL hid_t H5Aget_type(hid_t attr_id);
H5_DLL herr_t H5Aiterate2(hid_t loc_id, H5_index_t idx_type, H5_iter_order_t order, hsize_t *idx,
                          H5A_operator2_t op, void *op_data);
H5_DLL herr_t H5Aiterate_by_name(hid_t loc_id, const char *obj_name, H5_index_t idx_type,
                                 H5_iter_order_t order, hsize_t *idx, H5A_operator2_t op, void *op_data,
                                 hid_t lapl_id);
H5_DLL hid_t H5Aopen(hid_t obj_id, const char *attr_name, hid_t aapl_id);
#ifndef H5_DOXYGEN
H5_DLL hid_t H5Aopen_async(const char *app_file, const char *app_func, unsigned app_line, hid_t obj_id,
                           const char *attr_name, hid_t aapl_id, hid_t es_id);
#else
H5_DLL hid_t H5Aopen_async(hid_t obj_id, const char *attr_name, hid_t aapl_id, hid_t es_id);
#endif
H5_DLL hid_t H5Aopen_by_idx(hid_t loc_id, const char *obj_name, H5_index_t idx_type, H5_iter_order_t order,
                            hsize_t n, hid_t aapl_id, hid_t lapl_id);
#ifndef H5_DOXYGEN
H5_DLL hid_t H5Aopen_by_idx_async(const char *app_file, const char *app_func, unsigned app_line, hid_t loc_id,
                                  const char *obj_name, H5_index_t idx_type, H5_iter_order_t order, hsize_t n,
                                  hid_t aapl_id, hid_t lapl_id, hid_t es_id);
#else
H5_DLL hid_t H5Aopen_by_idx_async(hid_t loc_id, const char *obj_name, H5_index_t idx_type,
                                  H5_iter_order_t order, hsize_t n, hid_t aapl_id, hid_t lapl_id,
                                  hid_t es_id);
#endif
H5_DLL hid_t H5Aopen_by_name(hid_t loc_id, const char *obj_name, const char *attr_name, hid_t aapl_id,
                             hid_t lapl_id);
#ifndef H5_DOXYGEN
H5_DLL hid_t H5Aopen_by_name_async(const char *app_file, const char *app_func, unsigned app_line,
                                   hid_t loc_id, const char *obj_name, const char *attr_name, hid_t aapl_id,
                                   hid_t lapl_id, hid_t es_id);
#else
H5_DLL hid_t H5Aopen_by_name_async(hid_t loc_id, const char *obj_name, const char *attr_name, hid_t aapl_id,
                                   hid_t lapl_id, hid_t es_id);
#endif
H5_DLL herr_t H5Aread(hid_t attr_id, hid_t type_id, void *buf);
#ifndef H5_DOXYGEN
H5_DLL herr_t H5Aread_async(const char *app_file, const char *app_func, unsigned app_line, hid_t attr_id,
                            hid_t dtype_id, void *buf, hid_t es_id);
#else
H5_DLL herr_t H5Aread_async(hid_t attr_id, hid_t dtype_id, void *buf, hid_t es_id);
#endif
H5_DLL herr_t H5Arename(hid_t loc_id, const char *old_name, const char *new_name);
#ifndef H5_DOXYGEN
H5_DLL herr_t H5Arename_async(const char *app_file, const char *app_func, unsigned app_line, hid_t loc_id,
                              const char *old_name, const char *new_name, hid_t es_id);
#else
H5_DLL herr_t H5Arename_async(hid_t loc_id, const char *old_name, const char *new_name, hid_t es_id);
#endif
#ifndef H5_DOXYGEN
H5_DLL herr_t H5Arename_by_name_async(const char *app_file, const char *app_func, unsigned app_line,
                                      hid_t loc_id, const char *obj_name, const char *old_attr_name,
                                      const char *new_attr_name, hid_t lapl_id, hid_t es_id);
#else
H5_DLL herr_t H5Arename_by_name_async(hid_t loc_id, const char *obj_name, const char *old_attr_name,
                                      const char *new_attr_name, hid_t lapl_id, hid_t es_id);
#endif
H5_DLL herr_t H5Awrite(hid_t attr_id, hid_t type_id, const void *buf);
#ifndef H5_DOXYGEN
H5_DLL herr_t H5Awrite_async(const char *app_file, const char *app_func, unsigned app_line, hid_t attr_id,
                             hid_t type_id, const void *buf, hid_t es_id);
#else
H5_DLL herr_t H5Awrite_async(hid_t attr_id, hid_t type_id, const void *buf, hid_t es_id);
#endif
H5_DLL herr_t H5Arename_by_name(hid_t loc_id, const char *obj_name, const char *old_attr_name,
                                const char *new_attr_name, hid_t lapl_id);
/// \cond DEV
#ifndef H5A_MODULE
#define H5Acreate_async(...)         H5Acreate_async(__FILE__, __func__, __LINE__, __VA_ARGS__)
#define H5Acreate_by_name_async(...) H5Acreate_by_name_async(__FILE__, __func__, __LINE__, __VA_ARGS__)
#define H5Aopen_async(...)           H5Aopen_async(__FILE__, __func__, __LINE__, __VA_ARGS__)
#define H5Aopen_by_name_async(...)   H5Aopen_by_name_async(__FILE__, __func__, __LINE__, __VA_ARGS__)
#define H5Aopen_by_idx_async(...)    H5Aopen_by_idx_async(__FILE__, __func__, __LINE__, __VA_ARGS__)
#define H5Awrite_async(...)          H5Awrite_async(__FILE__, __func__, __LINE__, __VA_ARGS__)
#define H5Aread_async(...)           H5Aread_async(__FILE__, __func__, __LINE__, __VA_ARGS__)
#define H5Arename_async(...)         H5Arename_async(__FILE__, __func__, __LINE__, __VA_ARGS__)
#define H5Arename_by_name_async(...) H5Arename_by_name_async(__FILE__, __func__, __LINE__, __VA_ARGS__)
#define H5Aexists_async(...)         H5Aexists_async(__FILE__, __func__, __LINE__, __VA_ARGS__)
#define H5Aexists_by_name_async(...) H5Aexists_by_name_async(__FILE__, __func__, __LINE__, __VA_ARGS__)
#define H5Aclose_async(...)          H5Aclose_async(__FILE__, __func__, __LINE__, __VA_ARGS__)
#define H5Acreate_async_wrap         H5_NO_EXPAND(H5Acreate_async)
#define H5Acreate_by_name_async_wrap H5_NO_EXPAND(H5Acreate_by_name_async)
#define H5Aopen_async_wrap           H5_NO_EXPAND(H5Aopen_async)
#define H5Aopen_by_name_async_wrap   H5_NO_EXPAND(H5Aopen_by_name_async)
#define H5Aopen_by_idx_async_wrap    H5_NO_EXPAND(H5Aopen_by_idx_async)
#define H5Awrite_async_wrap          H5_NO_EXPAND(H5Awrite_async)
#define H5Aread_async_wrap           H5_NO_EXPAND(H5Aread_async)
#define H5Arename_async_wrap         H5_NO_EXPAND(H5Arename_async)
#define H5Arename_by_name_async_wrap H5_NO_EXPAND(H5Arename_by_name_async)
#define H5Aexists_async_wrap         H5_NO_EXPAND(H5Aexists_async)
#define H5Aexists_by_name_async_wrap H5_NO_EXPAND(H5Aexists_by_name_async)
#define H5Aclose_async_wrap          H5_NO_EXPAND(H5Aclose_async)
#endif
/// \endcond
#ifndef H5_NO_DEPRECATED_SYMBOLS
//! <!-- [H5A_operator1_t_snip] -->
typedef herr_t (*H5A_operator1_t)(hid_t location_id, const char *attr_name,
                                  void *operator_data);
//! <!-- [H5A_operator1_t_snip] -->
H5_DLL hid_t H5Acreate1(hid_t loc_id, const char *name, hid_t type_id, hid_t space_id, hid_t acpl_id);
H5_DLL int H5Aget_num_attrs(hid_t loc_id);
H5_DLL herr_t H5Aiterate1(hid_t loc_id, unsigned *idx, H5A_operator1_t op, void *op_data);
H5_DLL hid_t H5Aopen_idx(hid_t loc_id, unsigned idx);
H5_DLL hid_t H5Aopen_name(hid_t loc_id, const char *name);
#endif
#ifdef __cplusplus
}
#endif
#endif
