/*
 * Decompiled with CFR 0.152.
 */
package org.act.rscat.cat;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.act.rscat.cat.CatEngine;
import org.act.rscat.cat.CatFunctions;
import org.act.rscat.cat.CatHelper;
import org.act.rscat.cat.CatInput;
import org.act.rscat.cat.CatItemsToAdminister;
import org.act.rscat.cat.CatOutput;
import org.act.rscat.cat.CatOutputStandard;
import org.act.rscat.cat.ExposureControlFunctions;
import org.act.rscat.cat.ExposureControlType;
import org.act.rscat.cat.ItemSelectionMethodFactory;
import org.act.rscat.cat.PassageOrItemEligibilityAtThetaRange;
import org.act.rscat.cat.ScoringMethod;
import org.act.rscat.cat.ScoringMethodConfigEap;
import org.act.rscat.cat.ScoringMethodEap;
import org.act.rscat.cat.ThetaEst;
import org.act.rscat.mip.SolverInputSingleItem;
import org.act.rscat.mip.SolverInputSinglePassage;
import org.act.rscat.mip.SolverOutput;
import org.act.rscat.sol.InfeasibleTestConfigException;
import org.act.rscat.sol.ShadowTestRun;
import org.act.rscat.testdef.Item;
import org.act.rscat.util.ContentTable;
import org.act.rscat.util.PrimitiveArraySet;
import org.act.rscat.util.PrimitiveArrays;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.util.Precision;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatEngineStandard
implements CatEngine {
    public static final CatEngine INSTANCE = new CatEngineStandard();
    private static final Logger LOGGER = LoggerFactory.getLogger(CatEngineStandard.class);
    private static final String HEADER_FISHER_INFORMATION = CatEngine.MapIndiceHeader.FISHER_INFORMATION.name();
    private static final String HEADER_ITEM_IDENTIFIERS = CatEngine.MapIndiceHeader.ITEM_IDENTIFIERS.name();
    private static final String HEADER_ITEMS_ADMINISTERED = CatEngine.MapIndiceHeader.ITEMS_ADMINISTERED.name();
    private static final String HEADER_PASSAGE_IDENTIFIERS = CatEngine.MapIndiceHeader.PASSAGE_IDENTIFIERS.name();
    private static final String HEADER_ITEM_INDICES = CatEngine.MapIndiceHeader.ITEM_INDICES.name();
    private ShadowTestRun shadowTestRun;
    private CatItemsToAdminister itemsToAdminister;
    private ThetaEst thetaEst;
    private boolean testComplete = false;
    private double solverTimeSecs = 0.0;
    private PassageOrItemEligibilityAtThetaRange passageOrItemEligibilityAtThetaRange;
    private List<String> shadowTest;
    private ScoringMethod scoringMethod;
    private int testLength;
    private int completedCount;
    private ContentTable passagePoolTable;
    private RealMatrix itemPar;
    private String[] itemIds;
    private String[] passageIdsFromItemTable;
    private int[] itemIndices;
    private String[] passageIdsFromPassageTable;
    private boolean[] itemsAdministeredBoolean;
    private String[] itemsAdministeredString;
    private int[] rowIndicesItemsAdmin;
    private ExposureControlType exposureControlType;

    private CatEngineStandard() {
    }

    @Override
    public CatOutput runsCatCycle(CatInput catInput) throws IOException, InfeasibleTestConfigException {
        this.completedCount = catInput.getCompletedCount();
        LOGGER.debug("runsCatCycle starts for stage {}", (Object)this.completedCount);
        long startTime = System.currentTimeMillis();
        this.initialize(catInput);
        if (this.completedCount > this.testLength) {
            throw new IllegalArgumentException("Number of items completed cannot exceed total items");
        }
        if (this.testIsComplete()) {
            this.setupShadowTestRun(catInput);
            this.processCompleteTest(catInput);
        } else {
            if (this.completedCount == 0) {
                this.initializeShadowTestRun(catInput);
            }
            startTime = System.currentTimeMillis();
            this.setupShadowTestRun(catInput);
            this.refreshShadowTest(catInput);
        }
        double catEngineTime = (double)(System.currentTimeMillis() - startTime) / 1000.0;
        CatOutputStandard catOutput = new CatOutputStandard(this.itemsToAdminister, this.thetaEst, this.testComplete, this.passageOrItemEligibilityAtThetaRange, this.shadowTest, catEngineTime, Precision.round((double)this.solverTimeSecs, (int)3));
        LOGGER.debug("runsCatCycle ends for stage {} with CAT engine time {}second", (Object)this.completedCount, (Object)catEngineTime);
        return catOutput;
    }

    private void refreshShadowTest(CatInput catInput) throws IOException, InfeasibleTestConfigException {
        double[] fisherInformation = null;
        if (!catInput.getCatConfig().scoringMethodConfig().scoringMethod().equals((Object)ScoringMethod.SUPPORTED_METHODS.EAP)) {
            throw new IllegalArgumentException("The scoring method specified is not supported!");
        }
        fisherInformation = ItemSelectionMethodFactory.getInstance(catInput.getCatConfig().itemSelectionMethod(), this.itemPar, this.thetaEst.getTheta(), this.thetaEst.getSe()).getSelectionCriteria();
        if (catInput.getCatConfig().lValue() > catInput.getAdaptiveStage()) {
            fisherInformation = ExposureControlFunctions.applyLRandomToInfo(catInput.getCatConfig().lValue(), catInput.getAdaptiveStage(), fisherInformation);
        }
        boolean[] eligibilityIndicatorsItemSoft = new boolean[this.itemIds.length];
        boolean[] eligibilityIndicatorsPassageSoft = new boolean[this.passageIdsFromPassageTable.length];
        double bigM = 0.0;
        if (this.exposureControlEnabled()) {
            bigM = this.initalizeExposureControl(catInput, eligibilityIndicatorsItemSoft, eligibilityIndicatorsPassageSoft, fisherInformation);
        } else {
            this.clearExposureControl(eligibilityIndicatorsItemSoft, eligibilityIndicatorsPassageSoft);
        }
        boolean[] eligibilityIndicatorsItemSoftForAudit = new boolean[eligibilityIndicatorsItemSoft.length];
        System.arraycopy(eligibilityIndicatorsItemSoft, 0, eligibilityIndicatorsItemSoftForAudit, 0, eligibilityIndicatorsItemSoftForAudit.length);
        for (int adminIndex = 0; adminIndex < this.rowIndicesItemsAdmin.length; ++adminIndex) {
            int alreadyAdministered = this.rowIndicesItemsAdmin[adminIndex];
            if (eligibilityIndicatorsItemSoft[alreadyAdministered]) continue;
            eligibilityIndicatorsItemSoft[alreadyAdministered] = true;
        }
        boolean[] eligiblePassageItemsHard = new boolean[this.itemIds.length];
        Arrays.fill(eligiblePassageItemsHard, true);
        PrimitiveArraySet mapIndices = new PrimitiveArraySet();
        if (catInput.getTestConfig().getPassageTable().rowCount() > 0) {
            mapIndices = mapIndices.withStringArray(HEADER_ITEM_IDENTIFIERS, this.itemIds).withStringArray(HEADER_PASSAGE_IDENTIFIERS, this.passageIdsFromItemTable).withIntArray(HEADER_ITEM_INDICES, this.itemIndices).withDoubleArray(HEADER_FISHER_INFORMATION, fisherInformation).withBooleanArray(HEADER_ITEMS_ADMINISTERED, this.itemsAdministeredBoolean);
            eligiblePassageItemsHard = CatFunctions.getEligiblePassageItems(this.itemsAdministeredString, mapIndices, catInput.getTestConfig().getItemPoolTable());
        } else {
            mapIndices = mapIndices.withStringArray(HEADER_ITEM_IDENTIFIERS, this.itemIds).withIntArray(HEADER_ITEM_INDICES, this.itemIndices).withDoubleArray(HEADER_FISHER_INFORMATION, fisherInformation).withBooleanArray(HEADER_ITEMS_ADMINISTERED, this.itemsAdministeredBoolean);
        }
        List<SolverInputSingleItem> solverInputSingleItemList = ExposureControlFunctions.prepItemDataForSolver(this.itemIds, fisherInformation, this.itemsAdministeredBoolean, eligibilityIndicatorsItemSoft, eligiblePassageItemsHard, catInput.getShadowTest().toArray(new String[0]));
        List<SolverInputSinglePassage> solverInputSinglePassageList = ExposureControlFunctions.prepPassageDataForSolver(this.passageIdsFromPassageTable, eligibilityIndicatorsPassageSoft);
        SolverOutput outputData = this.shadowTestRun.runShadowTestAssembly(catInput.getAdaptiveStage(), solverInputSingleItemList, solverInputSinglePassageList, this.thetaEst.getTheta(), bigM, this.passageOrItemEligibilityAtThetaRange.getExposureType());
        if (outputData.getSolverStatus().equals((Object)SolverOutput.SOLVER_STATS.INFEASIBLE) || outputData.getSelectedItemIdentifiers().isEmpty()) {
            throw new InfeasibleTestConfigException("Test configuration is not feasible.Please check the configuration parameters and/or constraitns");
        }
        this.solverTimeSecs = this.shadowTestRun.getTestAssembly().getTotalSolverTime();
        this.itemsToAdminister = CatFunctions.prepShadowTest(this.itemsAdministeredString, outputData.getSelectedItemRowIndicesArray(), mapIndices, catInput.getTestConfig().getItemPoolTable(), this.passagePoolTable, outputData.getPassageRowIndexSequence());
        this.shadowTest = outputData.getSelectedItemIdentifiers();
    }

    private void clearExposureControl(boolean[] eligibilityIndicatorsItemSoft, boolean[] eligibilityIndicatorsPassageSoft) {
        for (int i = 0; i < this.itemIds.length; ++i) {
            eligibilityIndicatorsItemSoft[i] = true;
        }
        for (int j = 0; j < this.passageIdsFromPassageTable.length; ++j) {
            eligibilityIndicatorsPassageSoft[j] = true;
        }
        this.passageOrItemEligibilityAtThetaRange.setExposureControlType(ExposureControlType.NONE);
    }

    private double initalizeExposureControl(CatInput data, boolean[] eligibilityIndicatorsItemSoft, boolean[] eligibilityIndicatorsPassageSoft, double[] fisherInformation) {
        this.passageOrItemEligibilityAtThetaRange = ExposureControlFunctions.findThetaInterval(data.getPassageOrItemEligibilityOverall(), this.thetaEst);
        if (ExposureControlType.ITEM.equals((Object)this.passageOrItemEligibilityAtThetaRange.getExposureType())) {
            boolean[] eligibilityIndicatorsItemSoftOriginal = this.passageOrItemEligibilityAtThetaRange.getEligibilityIndicators();
            System.arraycopy(eligibilityIndicatorsItemSoftOriginal, 0, eligibilityIndicatorsItemSoft, 0, eligibilityIndicatorsItemSoft.length);
            for (int j = 0; j < this.passageIdsFromPassageTable.length; ++j) {
                eligibilityIndicatorsPassageSoft[j] = true;
            }
        } else if (ExposureControlType.PASSAGE.equals((Object)this.passageOrItemEligibilityAtThetaRange.getExposureType())) {
            for (int i = 0; i < this.itemIds.length; ++i) {
                eligibilityIndicatorsItemSoft[i] = true;
            }
            boolean[] eligibilityIndicatorsPassageSoftOriginal = this.passageOrItemEligibilityAtThetaRange.getEligibilityIndicators();
            System.arraycopy(eligibilityIndicatorsPassageSoftOriginal, 0, eligibilityIndicatorsPassageSoft, 0, eligibilityIndicatorsPassageSoft.length);
        }
        double maxInfo = 0.0;
        for (int i = 0; i < fisherInformation.length; ++i) {
            if (!(fisherInformation[i] > maxInfo)) continue;
            maxInfo = fisherInformation[i];
        }
        return maxInfo * 1.5;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setupShadowTestRun(CatInput catInput) {
        if (catInput.getAdaptiveStage() == 0) {
            double initTheta = catInput.getCatConfig().initTheta();
            if (!catInput.getCatConfig().scoringMethodConfig().scoringMethod().equals((Object)ScoringMethod.SUPPORTED_METHODS.EAP)) throw new IllegalArgumentException("The scoring method is not supported!");
            this.thetaEst = new ThetaEst(initTheta, 1.0);
            return;
        } else {
            RealMatrix itemParForScoring = this.itemPar.getSubMatrix(this.rowIndicesItemsAdmin, new int[]{0, 1, 2, 3});
            if (catInput.getCatConfig().scoringMethodConfig().scoringMethod() == ScoringMethod.SUPPORTED_METHODS.EAP) {
                this.scoringMethod = new ScoringMethodEap(itemParForScoring, catInput.getItemScores(), (ScoringMethodConfigEap)catInput.getCatConfig().scoringMethodConfig());
            }
            this.thetaEst = this.scoringMethod.estimateTheta();
        }
    }

    private boolean testIsComplete() {
        return this.testLength == this.completedCount;
    }

    private void processCompleteTest(CatInput data) {
        this.itemsToAdminister = new CatItemsToAdminister(new ArrayList<String>(), data.getItemsAdmin(), 1);
        this.testComplete = true;
    }

    private boolean exposureControlEnabled() {
        return this.exposureControlType == ExposureControlType.ITEM || this.exposureControlType == ExposureControlType.PASSAGE;
    }

    private void initializeShadowTestRun(CatInput catInput) throws IOException {
        this.shadowTestRun = new ShadowTestRun(catInput);
    }

    private void initialize(CatInput catInput) {
        int i;
        this.testLength = catInput.getTestConfig().getTestLength();
        this.passagePoolTable = catInput.getTestConfig().getPassageTable();
        this.itemPar = CatHelper.getItemParams(catInput.getItemPoolDataSet());
        this.itemIds = catInput.getItemPoolDataSet().getStringArrayCopy(Item.ColumnName.ITEM_ID.getColName());
        this.passageIdsFromItemTable = catInput.getItemPoolDataSet().getStringArrayCopy(Item.ColumnName.ITEM_PASSAGE_ID.getColName());
        this.itemIndices = new int[this.itemIds.length];
        for (i = 0; i < this.itemIndices.length; ++i) {
            this.itemIndices[i] = i;
        }
        this.passageIdsFromPassageTable = new String[catInput.getTestConfig().getPassageTable().rowCount()];
        for (i = 0; i < catInput.getTestConfig().getPassageTable().rowCount(); ++i) {
            this.passageIdsFromPassageTable[i] = catInput.getTestConfig().getPassageTable().rows().get(i).get(0);
        }
        this.shadowTest = new ArrayList<String>(this.testLength);
        this.exposureControlType = catInput.getPassageOrItemEligibility().getExposureType();
        this.passageOrItemEligibilityAtThetaRange = new PassageOrItemEligibilityAtThetaRange();
        this.passageOrItemEligibilityAtThetaRange.setExposureControlType(this.exposureControlType);
        this.itemsAdministeredBoolean = new boolean[this.itemPar.getRowDimension()];
        this.itemsAdministeredString = catInput.getItemsAdmin().toArray(new String[0]);
        this.rowIndicesItemsAdmin = PrimitiveArrays.select(this.itemIds, this.itemsAdministeredString);
        for (int adminIndex = 0; adminIndex < this.rowIndicesItemsAdmin.length; ++adminIndex) {
            int alreadyAdministered = this.rowIndicesItemsAdmin[adminIndex];
            this.itemsAdministeredBoolean[alreadyAdministered] = true;
        }
    }
}

