/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.datatypes.xsd.impl;

import com.hp.hpl.jena.datatypes.DatatypeFormatException;
import com.hp.hpl.jena.datatypes.xsd.XSDDuration;
import com.hp.hpl.jena.datatypes.xsd.impl.XSDAbstractDateTimeType;

public class XSDDurationType
extends XSDAbstractDateTimeType {
    public XSDDurationType() {
        super("duration");
        this.javaClass = XSDDuration.class;
    }

    public Object parseValidated(String str) {
        int end;
        int endDate;
        char c;
        int len = str.length();
        int[] date = new int[9];
        int start = 0;
        if ((c = str.charAt(start++)) != 'P' && c != '-') {
            throw new DatatypeFormatException("Internal error: validated duration failed to parse(1)");
        }
        int n = date[7] = c == '-' ? 45 : 0;
        if (c == '-' && str.charAt(start++) != 'P') {
            throw new DatatypeFormatException("Internal error: validated duration failed to parse(2)");
        }
        int negate = 1;
        if (date[7] == 45) {
            negate = -1;
        }
        if ((endDate = this.indexOf(str, start, len, 'T')) == -1) {
            endDate = len;
        }
        if ((end = this.indexOf(str, start, endDate, 'Y')) != -1) {
            date[0] = negate * this.parseInt(str, start, end);
            start = end + 1;
        }
        if ((end = this.indexOf(str, start, endDate, 'M')) != -1) {
            date[1] = negate * this.parseInt(str, start, end);
            start = end + 1;
        }
        if ((end = this.indexOf(str, start, endDate, 'D')) != -1) {
            date[2] = negate * this.parseInt(str, start, end);
            start = end + 1;
        }
        if (len == endDate && start != len) {
            throw new DatatypeFormatException("Internal error: validated duration failed to parse(3)");
        }
        if (len != endDate) {
            if ((end = this.indexOf(str, ++start, len, 'H')) != -1) {
                date[3] = negate * this.parseInt(str, start, end);
                start = end + 1;
            }
            if ((end = this.indexOf(str, start, len, 'M')) != -1) {
                date[4] = negate * this.parseInt(str, start, end);
                start = end + 1;
            }
            if ((end = this.indexOf(str, start, len, 'S')) != -1) {
                int mlsec = this.indexOf(str, start, end, '.');
                if (mlsec > 0) {
                    date[5] = negate * this.parseInt(str, start, mlsec);
                    int msEnd = end;
                    while (str.charAt(msEnd - 1) == '0') {
                        --msEnd;
                    }
                    date[6] = negate * this.parseInt(str, mlsec + 1, msEnd);
                    date[8] = msEnd - mlsec - 1;
                } else {
                    date[5] = negate * this.parseInt(str, start, end);
                }
                start = end + 1;
            }
        }
        return new XSDDuration(date);
    }
}

