/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.information;

import ec.tstoolkit.algorithm.IProcResults;
import ec.tstoolkit.algorithm.ProcessingInformation;
import ec.tstoolkit.information.InformationSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ProxyResults
implements IProcResults {
    public static final String ALL = "all";
    private final String name_;
    private final InformationSet info_;
    private LinkedHashMap<String, Class> map = new LinkedHashMap();

    public ProxyResults(InformationSet info, String name) {
        this.name_ = name;
        this.info_ = info;
        this.info_.fillDictionary(this.name_, this.map);
        this.map.put(ALL, InformationSet.class);
    }

    public InformationSet getInformationSet() {
        return this.info_;
    }

    @Override
    public boolean contains(String id) {
        return this.map.containsKey(id);
    }

    @Override
    public Map<String, Class> getDictionary() {
        return Collections.unmodifiableMap(this.map);
    }

    @Override
    public <T> T getData(String id, Class<T> tclass) {
        if (id.equals(ALL) && tclass.equals(InformationSet.class)) {
            return (T)this.info_;
        }
        return this.info_.search(id, tclass);
    }

    @Override
    public List<ProcessingInformation> getProcessingInformation() {
        ArrayList<ProcessingInformation> infos = new ArrayList<ProcessingInformation>();
        List<String> errors = this.info_.errors();
        for (String e : errors) {
            infos.add(ProcessingInformation.error(this.name_, e));
        }
        List<String> wrn = this.info_.warnings();
        for (String e : wrn) {
            infos.add(ProcessingInformation.warning(this.name_, e));
        }
        return infos;
    }
}

