/*
 * Decompiled with CFR 0.152.
 */
package core.explorer;

import core.explorer.ChordalysisModeller;
import core.model.ScoredGraphAction;
import core.stats.MessageLengthFactorialComputer;
import core.stats.scorer.GraphActionScorer;
import core.stats.scorer.GraphActionScorerMML;

public class ChordalysisModellingMML
extends ChordalysisModeller {
    MessageLengthFactorialComputer computer;

    @Override
    protected GraphActionScorer initScorer() {
        this.computer = new MessageLengthFactorialComputer(this.lattice);
        return new GraphActionScorerMML(this.computer);
    }

    public ChordalysisModellingMML(ChordalysisModeller.Data data) {
        super(data);
    }

    protected double getMMLGraphStructure(int nEdges) {
        int nVariables = this.lattice.getNbVariables();
        int maxNEdges = (int)((double)(nVariables * (nVariables - 1)) / 2.0);
        double MML = 0.0;
        MML += this.computer.getLogFromTable(1 + maxNEdges);
        MML += this.computer.getLogFactorials()[maxNEdges];
        MML -= this.computer.getLogFactorials()[nEdges];
        return MML -= this.computer.getLogFactorials()[maxNEdges - nEdges];
    }

    @Override
    public void explore() {
        this.pq.processStoredModifications();
        int nVariables = this.lattice.getNbVariables();
        int maxNEdges = (int)((double)(nVariables * (nVariables - 1)) / 2.0);
        int nEdgesReferenceModel = 0;
        double MMLRef = this.bestModel.getMessageLength(this.computer);
        double MMLGraphStructureRef = this.computer.getLogFromTable(1 + maxNEdges);
        double fullMMLRef = MMLRef + MMLGraphStructureRef;
        int step = 0;
        while (!this.pq.isEmpty() && step < this.maxNSteps) {
            double MMLGraphStructureCandidate;
            ScoredGraphAction todo = (ScoredGraphAction)this.pq.poll();
            double MMLCandidate = MMLRef + todo.getScore();
            double fullMMLCandidate = MMLCandidate + (MMLGraphStructureCandidate = this.getMMLGraphStructure(nEdgesReferenceModel + 1));
            if (fullMMLCandidate >= fullMMLRef) break;
            this.operationsPerformed.add(todo);
            this.bestModel.performAction(todo, this.bestModel, this.pq);
            ++nEdgesReferenceModel;
            MMLGraphStructureRef = MMLGraphStructureCandidate;
            MMLRef = MMLCandidate;
            fullMMLRef = fullMMLCandidate;
            ++step;
        }
    }
}

