/*
 * Decompiled with CFR 0.152.
 */
package dr.geo;

import dr.app.gui.ColorFunction;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;
import javax.swing.JComponent;

public class GTOPO30Tile
extends JComponent {
    static final int NROWS = 6000;
    static final int NCOLS = 4800;
    static final int NODATA = -9999;
    short[][] height;
    BufferedImage image;
    ColorFunction colorFunction;
    double ulxmap;
    double ulymap;
    double xdim;
    double ydim;
    Rectangle2D bounds;
    boolean createImage = true;

    public GTOPO30Tile(String string, ColorFunction colorFunction) throws IOException {
        String string2 = string.substring(0, string.lastIndexOf(46)) + ".HDR";
        File file = new File(string2);
        if (file.isFile()) {
            try {
                this.readHeader(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("No header file named " + file.toString() + " found");
            }
        }
        this.height = new short[6000][4800];
        this.colorFunction = colorFunction;
        this.read(string);
    }

    private void readHeader(File file) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = bufferedReader.readLine();
        while (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (stringTokenizer.countTokens() == 2) {
                hashMap.put(stringTokenizer.nextToken(), stringTokenizer.nextToken());
            }
            string = bufferedReader.readLine();
        }
        this.ulxmap = Double.parseDouble((String)hashMap.get("ULXMAP"));
        this.ulymap = Double.parseDouble((String)hashMap.get("ULYMAP"));
        this.xdim = Double.parseDouble((String)hashMap.get("XDIM"));
        this.ydim = Double.parseDouble((String)hashMap.get("YDIM"));
        this.bounds = new Rectangle2D.Double(this.ulxmap - this.xdim / 2.0, this.ulymap + this.ydim / 2.0 - this.ydim * 6000.0, this.xdim * 4800.0, this.ydim * 6000.0);
        if (6000 != Integer.parseInt((String)hashMap.get("NROWS"))) {
            throw new RuntimeException("Expected NROWS to be 6000 in header file " + file);
        }
        if (4800 != Integer.parseInt((String)hashMap.get("NCOLS"))) {
            throw new RuntimeException("Expected NCOLS to be 4800 in header file " + file);
        }
    }

    void read(String string) {
        if (this.createImage) {
            this.image = new BufferedImage(4800, 6000, 1);
        }
        try {
            ImageInputStream imageInputStream = ImageIO.createImageInputStream(new File(string));
            imageInputStream.setByteOrder(ByteOrder.BIG_ENDIAN);
            for (int i = 0; i < 6000; ++i) {
                imageInputStream.readFully(this.height[i], 0, 4800);
                if (!this.createImage) continue;
                for (int j = 0; j < 4800; ++j) {
                    short s = this.height[i][j];
                    if (s == -9999) {
                        this.image.setRGB(j, i, Color.blue.darker().getRGB());
                        continue;
                    }
                    this.image.setRGB(j, i, this.colorFunction.getColor((float)s).getRGB());
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.err.println();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        graphics.drawImage(this.image, 0, 0, n, n2, 0, 0, 4800, 6000, null);
    }

    public short getHeight(int n, int n2) {
        return this.height[n][n2];
    }

    boolean contains(double d, double d2) {
        return this.bounds.contains(d, d2);
    }

    public int getMinLongitude() {
        return (int)Math.round(this.bounds.getMinX());
    }

    public int getMaxLongitude() {
        return (int)Math.round(this.bounds.getMaxX());
    }

    public int getMinLatitude() {
        return (int)Math.round(this.bounds.getMinY());
    }

    public int getMaxLatitude() {
        return (int)Math.round(this.bounds.getMaxY());
    }
}

