/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.arg;

import dr.evomodel.arg.ARGModel;
import dr.inference.model.Statistic;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.logging.Logger;

public class ARGReassortmentTimingStatistic
extends Statistic.Abstract {
    private int dimension;
    private ARGModel arg;
    public static final String ARG_TIMING_STATISTIC = "argTimingStatistic";
    public static final String NUMBER_OF_REASSORTMENTS = "reassortments";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){

        @Override
        public String getParserDescription() {
            return "";
        }

        @Override
        public Class getReturnType() {
            return ARGReassortmentTimingStatistic.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return new XMLSyntaxRule[]{new ElementRule(ARGModel.class, false), AttributeRule.newStringRule("name", true)};
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            String string = xMLObject.getId();
            ARGModel aRGModel = (ARGModel)xMLObject.getChild(ARGModel.class);
            Logger.getLogger("dr.evomodel").info("Creating timing statistic");
            return new ARGReassortmentTimingStatistic(string, aRGModel);
        }

        @Override
        public String getParserName() {
            return ARGReassortmentTimingStatistic.ARG_TIMING_STATISTIC;
        }
    };

    public ARGReassortmentTimingStatistic(String string, ARGModel aRGModel) {
        super(string);
        this.dimension = aRGModel.getExternalNodeCount() + 1;
        this.arg = aRGModel;
    }

    @Override
    public int getDimension() {
        return this.dimension;
    }

    @Override
    public String getDimensionName(int n) {
        if (n == 0) {
            return "Root";
        }
        if (n == 1) {
            return "RootChild";
        }
        if (n == 2) {
            return "ENParent";
        }
        if (n == 3) {
            return "DNParent";
        }
        if (n == 4) {
            return "DCParent";
        }
        if (n == 5) {
            return "CCParent";
        }
        if (n == 6) {
            return "FNParent";
        }
        if (n == 7) {
            return "ReassortHeight";
        }
        if (n == 8) {
            return "CNParent";
        }
        if (n == 9) {
            return "CCParentParent";
        }
        return "";
    }

    @Override
    public double getStatisticValue(int n) {
        String string = "((((((<(FC,FN)>,CN),CC),<(FC,FN)>),DC),((EC,EN),DN)),AN);";
        if (!this.arg.toExtendedNewick().equals(string)) {
            return Double.NaN;
        }
        if (n == 0) {
            return this.arg.getRootHeightParameter().getParameterValue(0);
        }
        if (n == 1) {
            ARGModel.Node node = (ARGModel.Node)this.arg.getRoot();
            ARGModel.Node node2 = node.leftChild;
            ARGModel.Node node3 = node.rightChild;
            return Math.max(node2.heightParameter.getParameterValue(0), node3.heightParameter.getParameterValue(0));
        }
        if (n == 2) {
            int n2 = 0;
            ARGModel.Node node = (ARGModel.Node)this.arg.getExternalNode(0);
            while (!node.taxon.toString().equals("EN")) {
                node = (ARGModel.Node)this.arg.getExternalNode(++n2);
            }
            return node.leftParent.heightParameter.getParameterValue(0);
        }
        if (n == 3) {
            int n3 = 0;
            ARGModel.Node node = (ARGModel.Node)this.arg.getExternalNode(0);
            while (!node.taxon.toString().equals("DN")) {
                node = (ARGModel.Node)this.arg.getExternalNode(++n3);
            }
            return node.leftParent.heightParameter.getParameterValue(0);
        }
        if (n == 4) {
            int n4 = 0;
            ARGModel.Node node = (ARGModel.Node)this.arg.getExternalNode(0);
            while (!node.taxon.toString().equals("DC")) {
                node = (ARGModel.Node)this.arg.getExternalNode(++n4);
            }
            return node.leftParent.heightParameter.getParameterValue(0);
        }
        if (n == 5) {
            int n5 = 0;
            ARGModel.Node node = (ARGModel.Node)this.arg.getExternalNode(0);
            while (!node.taxon.toString().equals("CC")) {
                node = (ARGModel.Node)this.arg.getExternalNode(++n5);
            }
            return node.leftParent.heightParameter.getParameterValue(0);
        }
        if (n == 6) {
            int n6 = 0;
            ARGModel.Node node = (ARGModel.Node)this.arg.getExternalNode(0);
            while (!node.taxon.toString().equals("FN")) {
                node = (ARGModel.Node)this.arg.getExternalNode(++n6);
            }
            return node.leftParent.heightParameter.getParameterValue(0);
        }
        if (n == 7) {
            int n7 = 0;
            ARGModel.Node node = (ARGModel.Node)this.arg.getExternalNode(0);
            while (!node.taxon.toString().equals("FN")) {
                node = (ARGModel.Node)this.arg.getExternalNode(++n7);
            }
            return node.leftParent.leftParent.heightParameter.getParameterValue(0);
        }
        if (n == 8) {
            int n8 = 0;
            ARGModel.Node node = (ARGModel.Node)this.arg.getExternalNode(0);
            while (!node.taxon.toString().equals("CN")) {
                node = (ARGModel.Node)this.arg.getExternalNode(++n8);
            }
            return node.leftParent.heightParameter.getParameterValue(0);
        }
        int n9 = 0;
        ARGModel.Node node = (ARGModel.Node)this.arg.getExternalNode(0);
        while (!node.taxon.toString().equals("CC")) {
            node = (ARGModel.Node)this.arg.getExternalNode(++n9);
        }
        return node.leftParent.leftParent.heightParameter.getParameterValue(0);
    }
}

