/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.clientlibrary.lib.worker;

import java.beans.ConstructorProperties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class ThrottlingReporter {
    private static final Log log = LogFactory.getLog(ThrottlingReporter.class);
    private final int maxConsecutiveWarnThrottles;
    private final String shardId;
    private int consecutiveThrottles = 0;

    void throttled() {
        ++this.consecutiveThrottles;
        String message = "Shard '" + this.shardId + "' has been throttled " + this.consecutiveThrottles + " consecutively";
        if (this.consecutiveThrottles > this.maxConsecutiveWarnThrottles) {
            this.getLog().error((Object)message);
        } else {
            this.getLog().warn((Object)message);
        }
    }

    void success() {
        this.consecutiveThrottles = 0;
    }

    protected Log getLog() {
        return log;
    }

    @ConstructorProperties(value={"maxConsecutiveWarnThrottles", "shardId"})
    public ThrottlingReporter(int maxConsecutiveWarnThrottles, String shardId) {
        this.maxConsecutiveWarnThrottles = maxConsecutiveWarnThrottles;
        this.shardId = shardId;
    }
}

