/*
 * Decompiled with CFR 0.152.
 */
package org.ipea.r5r.R5;

import com.conveyal.r5.OneOriginResult;
import com.conveyal.r5.analyst.FreeFormPointSet;
import com.conveyal.r5.analyst.PointSet;
import com.conveyal.r5.analyst.StreetTimesAndModes;
import com.conveyal.r5.analyst.TravelTimeComputer;
import com.conveyal.r5.analyst.TravelTimeReducer;
import com.conveyal.r5.analyst.WebMercatorExtents;
import com.conveyal.r5.analyst.WebMercatorGridPointSet;
import com.conveyal.r5.analyst.cluster.AnalysisWorkerTask;
import com.conveyal.r5.analyst.cluster.PathWriter;
import com.conveyal.r5.analyst.cluster.RegionalTask;
import com.conveyal.r5.analyst.fare.InRoutingFareCalculator;
import com.conveyal.r5.analyst.scenario.PickupWaitTimes;
import com.conveyal.r5.api.util.LegMode;
import com.conveyal.r5.point_to_point.builder.PointToPointQuery;
import com.conveyal.r5.profile.DominatingList;
import com.conveyal.r5.profile.FareDominatingList;
import com.conveyal.r5.profile.FastRaptorWorker;
import com.conveyal.r5.profile.McRaptorSuboptimalPathProfileRouter;
import com.conveyal.r5.profile.PerTargetPropagater;
import com.conveyal.r5.profile.ProfileRequest;
import com.conveyal.r5.profile.StreetMode;
import com.conveyal.r5.streets.LinkedPointSet;
import com.conveyal.r5.streets.PointSetTimes;
import com.conveyal.r5.streets.Split;
import com.conveyal.r5.streets.StreetRouter;
import com.conveyal.r5.transit.TransitLayer;
import com.conveyal.r5.transit.TransportNetwork;
import com.conveyal.r5.transit.path.Path;
import gnu.trove.map.TIntIntMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class R5TravelTimeComputer
extends TravelTimeComputer {
    private static final Logger LOG = LoggerFactory.getLogger(R5TravelTimeComputer.class);
    private final AnalysisWorkerTask request;
    private final TransportNetwork network;

    public R5TravelTimeComputer(AnalysisWorkerTask request, TransportNetwork network) {
        super(request, network);
        this.request = request;
        this.network = network;
    }

    public OneOriginResult computeTravelTimes() {
        int[][] transitTravelTimesToStops;
        WebMercatorGridPointSet destinations;
        if (!this.request.directModes.equals(this.request.accessModes)) {
            throw new IllegalArgumentException("Direct mode may not be different than access mode in Analysis.");
        }
        if (this.request.inRoutingFareCalculator != null) {
            this.request.inRoutingFareCalculator.transitLayer = this.network.transitLayer;
        }
        TravelTimeReducer travelTimeReducer = new TravelTimeReducer(this.request, this.network);
        if (this.request instanceof RegionalTask && !this.request.makeTauiSite && this.request.destinationPointSets[0] instanceof FreeFormPointSet) {
            destinations = this.request.destinationPointSets[0];
        } else {
            WebMercatorExtents destinationGridExtents = this.request.getWebMercatorExtents();
            destinations = AnalysisWorkerTask.gridPointSetCache.get(destinationGridExtents, this.network.fullExtentGridPointSet);
            travelTimeReducer.checkOpportunityExtents((PointSet)destinations);
        }
        StreetTimesAndModes bestAccessOptions = new StreetTimesAndModes();
        PointSetTimes nonTransitTravelTimesToDestinations = null;
        boolean foundAnyOriginPoint = false;
        EnumSet accessModes = LegMode.toStreetModeSet((EnumSet[])new EnumSet[]{this.request.accessModes});
        for (StreetMode accessMode : accessModes) {
            LOG.info("Performing street search for mode: {}", (Object)accessMode);
            PickupWaitTimes.AccessService accessService = this.network.streetLayer.getAccessService(this.request.fromLat, this.request.fromLon, accessMode);
            if (accessService == PickupWaitTimes.NO_SERVICE_HERE) {
                LOG.info("On-demand {} service is not available at this location, continuing to next access mode (if any).", (Object)accessMode);
                continue;
            }
            StreetRouter sr = new StreetRouter(this.network.streetLayer);
            sr.profileRequest = this.request;
            sr.streetMode = accessMode;
            if (!sr.setOrigin(this.request.fromLat, this.request.fromLon)) {
                LOG.info("Origin point could not be linked to the street network for mode {}.", (Object)accessMode);
                continue;
            }
            foundAnyOriginPoint = true;
            int limitSeconds = this.request.maxTripDurationMinutes * 60;
            if (this.request.hasTransit()) {
                limitSeconds = Math.min(limitSeconds, this.request.getMaxTimeSeconds(accessMode));
            }
            sr.timeLimitSeconds = limitSeconds;
            sr.quantityToMinimize = StreetRouter.State.RoutingVariable.DURATION_SECONDS;
            sr.route();
            if (accessMode != StreetMode.WALK) {
                sr.keepRoutingOnFoot();
            }
            if (this.request.hasTransit()) {
                TIntIntMap travelTimesToStopsSeconds = sr.getReachedStops();
                if (accessService != PickupWaitTimes.NO_WAIT_ALL_STOPS) {
                    LOG.info("Delaying transit access times by {} seconds (to wait for {} pick-up).", (Object)accessService.waitTimeSeconds, (Object)accessMode);
                    if (accessService.stopsReachable != null) {
                        travelTimesToStopsSeconds.retainEntries((k, v) -> accessService.stopsReachable.contains(k));
                    }
                    travelTimesToStopsSeconds.transformValues(i -> i + accessService.waitTimeSeconds);
                }
                this.updateStreetTimesAndModes(bestAccessOptions, travelTimesToStopsSeconds, accessMode);
            }
            LinkedPointSet linkedDestinations = this.network.linkageCache.getLinkage((PointSet)destinations, this.network.streetLayer, accessMode);
            int streetSpeedMillimetersPerSecond = (int)(this.request.getSpeedForMode(accessMode) * 1000.0f);
            if (streetSpeedMillimetersPerSecond <= 0) {
                throw new IllegalArgumentException("Speed of access mode must be greater than 0.");
            }
            int walkSpeedMillimetersPerSecond = (int)(this.request.walkSpeed * 1000.0f);
            Split origin = sr.getOriginSplit();
            PointSetTimes pointSetTimes = linkedDestinations.eval(arg_0 -> ((StreetRouter)sr).getTravelTimeToVertex(arg_0), Integer.valueOf(streetSpeedMillimetersPerSecond), walkSpeedMillimetersPerSecond, origin);
            if (accessService != PickupWaitTimes.NO_WAIT_ALL_STOPS) {
                LOG.info("Delaying direct travel times by {} seconds (to wait for {} pick-up).", (Object)accessService.waitTimeSeconds, (Object)accessMode);
                if (accessService.stopsReachable != null) {
                    pointSetTimes = PointSetTimes.allUnreached((PointSet)destinations);
                } else {
                    pointSetTimes.incrementAllReachable(accessService.waitTimeSeconds);
                }
            }
            nonTransitTravelTimesToDestinations = PointSetTimes.minMerge((PointSetTimes)nonTransitTravelTimesToDestinations, (PointSetTimes)pointSetTimes);
        }
        if (this.request.accessModes.contains(LegMode.CAR_PARK)) {
            StreetRouter sr = new StreetRouter(this.network.streetLayer);
            sr.profileRequest = this.request;
            if ((sr = PointToPointQuery.findParkRidePath((ProfileRequest)this.request, (StreetRouter)sr, (TransitLayer)this.network.transitLayer)) == null) {
                foundAnyOriginPoint = false;
            } else {
                this.updateStreetTimesAndModes(bestAccessOptions, sr.getReachedStops(), StreetMode.CAR);
                foundAnyOriginPoint = true;
            }
            nonTransitTravelTimesToDestinations = PointSetTimes.allUnreached((PointSet)destinations);
        }
        if (!foundAnyOriginPoint) {
            LOG.info("Origin point was outside the street network. Skipping routing and propagation, and returning default result.");
            return travelTimeReducer.finish();
        }
        if (this.request.transitModes.isEmpty() || bestAccessOptions.streetTimesAndModes.isEmpty()) {
            LOG.info("Skipping transit search. No transit stops were reached or no transit modes were selected.");
            int nTargets = nonTransitTravelTimesToDestinations.size();
            if (this.request instanceof RegionalTask && ((RegionalTask)this.request).oneToOne) {
                nTargets = 1;
            }
            for (int target = 0; target < nTargets; ++target) {
                int travelTimeSeconds = nonTransitTravelTimesToDestinations.getTravelTimeToPoint(target);
                travelTimeReducer.recordUnvaryingTravelTimeAtTarget(target, travelTimeSeconds);
            }
            return travelTimeReducer.finish();
        }
        FastRaptorWorker worker = null;
        if (this.request.inRoutingFareCalculator == null) {
            worker = new FastRaptorWorker(this.network.transitLayer, this.request, bestAccessOptions.getTimes());
            if (this.request.includePathResults || this.request.makeTauiSite) {
                worker.retainPaths = true;
            }
            transitTravelTimesToStops = worker.route();
        } else {
            HashMap<LegMode, TIntIntMap> accessTimes = new HashMap<LegMode, TIntIntMap>();
            for (LegMode mode : this.request.accessModes) {
                accessTimes.put(mode, bestAccessOptions.getTimes());
            }
            IntFunction<DominatingList> listSupplier = departureTime -> new FareDominatingList(this.request.inRoutingFareCalculator, this.request.maxFare, departureTime + this.request.maxTripDurationMinutes * 60);
            McRaptorSuboptimalPathProfileRouter mcRaptorWorker = new McRaptorSuboptimalPathProfileRouter(this.network, (ProfileRequest)this.request, accessTimes, null, listSupplier, InRoutingFareCalculator.getCollator((ProfileRequest)this.request));
            mcRaptorWorker.route();
            transitTravelTimesToStops = mcRaptorWorker.getBestTimes();
        }
        EnumSet egressStreetModes = LegMode.toStreetModeSet((EnumSet[])new EnumSet[]{this.request.egressModes});
        PerTargetPropagater perTargetPropagater = new PerTargetPropagater((PointSet)destinations, this.network.streetLayer, egressStreetModes, this.request, transitTravelTimesToStops, nonTransitTravelTimesToDestinations.travelTimes);
        perTargetPropagater.travelTimeReducer = travelTimeReducer;
        if ((this.request.includePathResults || this.request.makeTauiSite) && worker != null) {
            perTargetPropagater.pathsToStopsForIteration = worker.pathsPerIteration.stream().peek(paths -> {
                for (Path path : paths) {
                    if (path == null) continue;
                    path.patternSequence.stopSequence.setAccess(bestAccessOptions);
                }
            }).collect(Collectors.toList());
            if (this.request.makeTauiSite) {
                perTargetPropagater.pathWriter = new PathWriter(this.request);
            }
        }
        return perTargetPropagater.propagate();
    }

    void updateStreetTimesAndModes(StreetTimesAndModes options, TIntIntMap times, StreetMode streetMode) {
        times.forEachEntry((stop, time) -> {
            if (!options.streetTimesAndModes.containsKey(stop) || time < ((StreetTimesAndModes.StreetTimeAndMode)options.streetTimesAndModes.get((int)stop)).time) {
                options.streetTimesAndModes.put(stop, (Object)new StreetTimesAndModes.StreetTimeAndMode(time, streetMode));
            }
            return true;
        });
    }
}

