/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
#ifndef H5Dprivate_H
#define H5Dprivate_H
#include "H5Dpublic.h"
#include "H5FDprivate.h"
#include "H5Oprivate.h"
#include "H5Sprivate.h"
#include "H5Zprivate.h"
#ifdef NDEBUG
#undef H5D_DEBUG
#endif
#define H5D_CRT_LAYOUT_NAME            "layout"
#define H5D_CRT_FILL_VALUE_NAME        "fill_value"
#define H5D_CRT_ALLOC_TIME_STATE_NAME  "alloc_time_state"
#define H5D_CRT_EXT_FILE_LIST_NAME     "efl"
#define H5D_CRT_MIN_DSET_HDR_SIZE_NAME "dset_oh_minimize"
#define H5D_ACS_DATA_CACHE_NUM_SLOTS_NAME "rdcc_nslots"
#define H5D_ACS_DATA_CACHE_BYTE_SIZE_NAME "rdcc_nbytes"
#define H5D_ACS_PREEMPT_READ_CHUNKS_NAME  "rdcc_w0"
#define H5D_ACS_VDS_VIEW_NAME             "vds_view"
#define H5D_ACS_VDS_PRINTF_GAP_NAME       "vds_printf_gap"
#define H5D_ACS_VDS_PREFIX_NAME           "vds_prefix"
#define H5D_ACS_APPEND_FLUSH_NAME         "append_flush"
#define H5D_ACS_EFILE_PREFIX_NAME         "external file prefix"
#define H5D_XFER_MAX_TEMP_BUF_NAME          "max_temp_buf"
#define H5D_XFER_TCONV_BUF_NAME             "tconv_buf"
#define H5D_XFER_BKGR_BUF_NAME              "bkgr_buf"
#define H5D_XFER_BKGR_BUF_TYPE_NAME         "bkgr_buf_type"
#define H5D_XFER_BTREE_SPLIT_RATIO_NAME     "btree_split_ratio"
#define H5D_XFER_VLEN_ALLOC_NAME            "vlen_alloc"
#define H5D_XFER_VLEN_ALLOC_INFO_NAME       "vlen_alloc_info"
#define H5D_XFER_VLEN_FREE_NAME             "vlen_free"
#define H5D_XFER_VLEN_FREE_INFO_NAME        "vlen_free_info"
#define H5D_XFER_VFL_ID_NAME                "vfl_id"
#define H5D_XFER_VFL_INFO_NAME              "vfl_info"
#define H5D_XFER_HYPER_VECTOR_SIZE_NAME     "vec_size"
#define H5D_XFER_IO_XFER_MODE_NAME          "io_xfer_mode"
#define H5D_XFER_MPIO_COLLECTIVE_OPT_NAME   "mpio_collective_opt"
#define H5D_XFER_MPIO_CHUNK_OPT_HARD_NAME   "mpio_chunk_opt_hard"
#define H5D_XFER_MPIO_CHUNK_OPT_NUM_NAME    "mpio_chunk_opt_num"
#define H5D_XFER_MPIO_CHUNK_OPT_RATIO_NAME  "mpio_chunk_opt_ratio"
#define H5D_MPIO_ACTUAL_CHUNK_OPT_MODE_NAME "actual_chunk_opt_mode"
#define H5D_MPIO_ACTUAL_IO_MODE_NAME        "actual_io_mode"
#define H5D_MPIO_LOCAL_NO_COLLECTIVE_CAUSE_NAME                                                              \
    "local_no_collective_cause"
#define H5D_MPIO_GLOBAL_NO_COLLECTIVE_CAUSE_NAME                                                             \
    "global_no_collective_cause"
#define H5D_XFER_EDC_NAME                      "err_detect"
#define H5D_XFER_FILTER_CB_NAME                "filter_cb"
#define H5D_XFER_CONV_CB_NAME                  "type_conv_cb"
#define H5D_XFER_XFORM_NAME                    "data_transform"
#define H5D_XFER_DSET_IO_SEL_NAME              "dset_io_selection"
#define H5D_XFER_SELECTION_IO_MODE_NAME        "selection_io_mode"
#define H5D_XFER_NO_SELECTION_IO_CAUSE_NAME    "no_selection_io_cause"
#define H5D_XFER_ACTUAL_SELECTION_IO_MODE_NAME "actual_selection_io_mode"
#define H5D_XFER_MODIFY_WRITE_BUF_NAME         "modify_write_buf"
#ifdef H5_HAVE_INSTRUMENTED_LIBRARY
#define H5D_XFER_COLL_CHUNK_LINK_HARD_NAME        "coll_chunk_link_hard"
#define H5D_XFER_COLL_CHUNK_MULTI_HARD_NAME       "coll_chunk_multi_hard"
#define H5D_XFER_COLL_CHUNK_LINK_NUM_TRUE_NAME    "coll_chunk_link_true"
#define H5D_XFER_COLL_CHUNK_LINK_NUM_FALSE_NAME   "coll_chunk_link_false"
#define H5D_XFER_COLL_CHUNK_MULTI_RATIO_COLL_NAME "coll_chunk_multi_coll"
#define H5D_XFER_COLL_CHUNK_MULTI_RATIO_IND_NAME  "coll_chunk_multi_ind"
#define H5D_XFER_COLL_CHUNK_SIZE sizeof(unsigned)
#define H5D_XFER_COLL_CHUNK_DEF  1
#define H5D_XFER_COLL_RANK0_BCAST_NAME "coll_rank0_bcast"
#define H5D_XFER_COLL_RANK0_BCAST_SIZE sizeof(bool)
#define H5D_XFER_COLL_RANK0_BCAST_DEF  false
#endif
#define H5D_TEMP_BUF_SIZE (1024 * 1024)
#define H5D_IO_VECTOR_SIZE 1024
#define H5D_VLEN_ALLOC      NULL
#define H5D_VLEN_ALLOC_INFO NULL
#define H5D_VLEN_FREE       NULL
#define H5D_VLEN_FREE_INFO  NULL
#define H5D_VIRTUAL_DEF_LIST_SIZE 8
#ifdef H5D_MODULE
#define H5D_OBJ_ID(D) (((H5D_obj_create_t *)(D))->dcpl_id)
#else
#define H5D_OBJ_ID(D) (H5D_get_dcpl_id(D))
#endif
typedef struct H5D_t            H5D_t;
typedef struct H5D_obj_create_t H5D_obj_create_t;
typedef struct H5D_dcpl_cache_t {
    H5O_fill_t  fill;
    H5O_pline_t pline;
    H5O_efl_t   efl;
} H5D_dcpl_cache_t;
typedef struct H5D_copy_file_ud_t {
    H5O_copy_file_ud_common_t common;
    struct H5S_extent_t      *src_space_extent;
    H5T_t                    *src_dtype;
} H5D_copy_file_ud_t;
typedef struct H5D_append_flush_t {
    unsigned        ndims;
    hsize_t         boundary[H5S_MAX_RANK];
    H5D_append_cb_t func;
    void           *udata;
} H5D_append_flush_t;
H5_DLL herr_t      H5D_init(void);
H5_DLL H5D_t      *H5D_open(const H5G_loc_t *loc, hid_t dapl_id);
H5_DLL herr_t      H5D_close(H5D_t *dataset);
H5_DLL herr_t      H5D_mult_refresh_close(hid_t dset_id);
H5_DLL herr_t      H5D_mult_refresh_reopen(H5D_t *dataset);
H5_DLL H5O_loc_t  *H5D_oloc(H5D_t *dataset);
H5_DLL H5G_name_t *H5D_nameof(H5D_t *dataset);
H5_DLL herr_t      H5D_flush_all(H5F_t *f);
H5_DLL hid_t       H5D_get_create_plist(const H5D_t *dset);
H5_DLL hid_t       H5D_get_access_plist(const H5D_t *dset);
H5_DLL hid_t       H5D_get_dcpl_id(const H5D_obj_create_t *d);
H5_DLL herr_t H5D_chunk_idx_reset(H5O_storage_chunk_t *storage, bool reset_addr);
H5_DLL herr_t H5D_virtual_check_mapping_pre(const H5S_t *vspace, const H5S_t *src_space,
                                            H5O_virtual_space_status_t space_status);
H5_DLL herr_t H5D_virtual_check_mapping_post(const H5O_storage_virtual_ent_t *ent);
H5_DLL herr_t H5D_virtual_check_min_dims(const H5D_t *dset);
H5_DLL herr_t H5D_virtual_update_min_dims(H5O_layout_t *layout, size_t idx);
H5_DLL herr_t H5D_virtual_parse_source_name(const char                      *source_name,
                                            H5O_storage_virtual_name_seg_t **parsed_name,
                                            size_t *static_strlen, size_t *nsubs);
H5_DLL herr_t H5D_virtual_free_parsed_name(H5O_storage_virtual_name_seg_t *name_seg);
H5_DLL herr_t H5D_btree_debug(H5F_t *f, haddr_t addr, FILE *stream, int indent, int fwidth, unsigned ndims,
                              const uint32_t *dim);
#endif
