/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators;

import dr.inference.operators.MCMCOperator;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;

public class TeamOperator
extends SimpleMCMCOperator {
    private final MCMCOperator[] operators;
    private final int nPick;
    private final boolean unequalWeights;
    private final MCMCOperator[] currentRound;
    private int nToReject;
    private int[][] binomial;

    public TeamOperator(MCMCOperator[] mCMCOperatorArray, int n, double d) {
        this.setWeight(d);
        this.operators = mCMCOperatorArray;
        int n2 = mCMCOperatorArray.length;
        assert (0 < n && n <= n2);
        this.nPick = n;
        this.currentRound = new MCMCOperator[n2];
        int n3 = 0;
        double d2 = mCMCOperatorArray[0].getWeight();
        for (MCMCOperator mCMCOperator : mCMCOperatorArray) {
            if (mCMCOperator.getWeight() == d2) continue;
            n3 = 1;
            break;
        }
        this.unequalWeights = n3;
        if (this.unequalWeights) {
            int n4;
            n3 = n2 + 1;
            this.binomial = new int[n3][n3];
            for (n4 = 0; n4 < n3; ++n4) {
                this.binomial[n4][0] = 1;
            }
            for (n4 = 1; n4 < n3; ++n4) {
                for (int i = 1; i <= n4; ++i) {
                    this.binomial[n4][i] = this.binomial[n4 - 1][i] + this.binomial[n4 - 1][i - 1];
                }
            }
        } else {
            for (n3 = 0; n3 < n2; ++n3) {
                this.currentRound[n3] = mCMCOperatorArray[n3];
            }
        }
    }

    private void choose() {
        int n = this.operators.length;
        if (this.nPick < n) {
            if (this.unequalWeights) {
                this.chooseUsingWeights();
            } else {
                for (int i = 0; i < this.nPick; ++i) {
                    int n2 = i + MathUtils.nextInt(n - i);
                    MCMCOperator mCMCOperator = this.currentRound[i];
                    this.currentRound[i] = this.currentRound[n2];
                    this.currentRound[n2] = mCMCOperator;
                }
            }
        }
    }

    private void chooseUsingWeights() {
        double d = 0.0;
        double d2 = 0.0;
        for (MCMCOperator mCMCOperator : this.operators) {
            d2 += mCMCOperator.getWeight();
        }
        int n = this.nPick;
        int n2 = 0;
        while (n > 0) {
            int n3 = this.operators.length - n2;
            if (n == n3) {
                while (n > 0) {
                    this.currentRound[n - 1] = this.operators[n2];
                    --n;
                    ++n2;
                }
                continue;
            }
            int n4 = this.binomial[n3][n];
            int n5 = this.binomial[n3 - 1][n - 1];
            int n6 = n >= 2 ? this.binomial[n3 - 2][n - 2] : 0;
            double d3 = (double)n5 * d2 + (double)n4 * d;
            double d4 = this.operators[n2].getWeight();
            double d5 = (double)n6 * (d2 - d4) + (double)n5 * (d4 + d);
            double d6 = MathUtils.nextDouble();
            if (d6 < d5 / d3) {
                this.currentRound[n - 1] = this.operators[n2];
                --n;
                d += d4;
            }
            ++n2;
            d2 -= d4;
        }
    }

    @Override
    public final double doOperation() {
        this.choose();
        double d = 0.0;
        for (int i = 0; i < this.nPick; ++i) {
            MCMCOperator mCMCOperator = this.currentRound[i];
            d += mCMCOperator.operate();
        }
        this.nToReject = this.nPick;
        return d;
    }

    @Override
    public void accept(double d) {
        super.accept(d);
        for (int i = 0; i < this.nPick; ++i) {
            this.currentRound[i].accept(d);
        }
    }

    @Override
    public void reject() {
        super.reject();
        for (int i = 0; i < this.nToReject; ++i) {
            this.currentRound[i].reject();
        }
    }

    @Override
    public void reset() {
        for (MCMCOperator mCMCOperator : this.operators) {
            mCMCOperator.reset();
        }
    }

    @Override
    public String getOperatorName() {
        StringBuffer stringBuffer = new StringBuffer("Team " + this.nPick + " (");
        for (MCMCOperator mCMCOperator : this.operators) {
            stringBuffer.append(mCMCOperator.getOperatorName() + ",");
        }
        return stringBuffer.substring(0, stringBuffer.length() - 1) + ")";
    }

    public String getPerformanceSuggestion() {
        return "";
    }
}

