/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.data;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collections;
import java.util.List;
import net.didion.jwnl.JWNL;
import net.didion.jwnl.data.DictionaryElement;
import net.didion.jwnl.data.DictionaryElementType;
import net.didion.jwnl.data.POS;

public final class Exc
implements DictionaryElement {
    static final long serialVersionUID = -5792651340274489357L;
    private POS _pos;
    private String _lemma;
    private List _exceptions;
    private transient String _cachedToString = null;
    private String _exceptionString = null;

    public Exc(POS pos, String lemma, List exceptions) {
        this._pos = pos;
        this._lemma = lemma;
        this._exceptions = Collections.unmodifiableList(exceptions);
    }

    public DictionaryElementType getType() {
        return DictionaryElementType.EXCEPTION;
    }

    public POS getPOS() {
        return this._pos;
    }

    public String getLemma() {
        return this._lemma;
    }

    public String getException(int index) {
        return (String)this.getExceptions().get(index);
    }

    public int getExceptionsSize() {
        return this.getExceptions().size();
    }

    public String[] getExceptionArray() {
        return this.getExceptions().toArray(new String[this._exceptions.size()]);
    }

    public List getExceptions() {
        return this._exceptions;
    }

    public Object getKey() {
        return this.getLemma();
    }

    public boolean equals(Object obj) {
        return obj instanceof Exc && this.getLemma().equals(((Exc)obj).getLemma()) && this.getExceptions().equals(((Exc)obj).getExceptions());
    }

    public String toString() {
        if (this._cachedToString == null) {
            this._cachedToString = JWNL.resolveMessage("DATA_TOSTRING_001", new Object[]{this.getLemma(), this.getExceptionsAsString()});
        }
        return this._cachedToString;
    }

    public int hashCode() {
        int hash = this.getLemma().hashCode();
        int i = 0;
        while (i < this.getExceptionsSize()) {
            hash ^= this.getException(i).hashCode();
            ++i;
        }
        return hash;
    }

    private String getExceptionsAsString() {
        if (this._exceptionString == null) {
            String str = "";
            int i = 0;
            while (i < this.getExceptionsSize()) {
                str = String.valueOf(str) + this.getException(i);
                if (i != this.getExceptionsSize() - 1) {
                    str = String.valueOf(str) + ", ";
                }
                ++i;
            }
            this._exceptionString = str;
        }
        return this._exceptionString;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this._pos = POS.getPOSForKey(this._pos.getKey());
    }
}

