/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.GraphRDB;
import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.RDFRDBException;
import com.hp.hpl.jena.db.impl.DBQuery;
import com.hp.hpl.jena.db.impl.DBQueryHandler;
import com.hp.hpl.jena.db.impl.DBQueryStageCompiler;
import com.hp.hpl.jena.db.impl.ResultSetIterator;
import com.hp.hpl.jena.db.impl.SpecializedGraph;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.query.BufferPipe;
import com.hp.hpl.jena.graph.query.Domain;
import com.hp.hpl.jena.graph.query.ExpressionSet;
import com.hp.hpl.jena.graph.query.Pipe;
import com.hp.hpl.jena.graph.query.Stage;
import com.hp.hpl.jena.shared.JenaException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;

public class DBQueryStage
extends Stage {
    protected Graph graph;
    protected DBQuery compiled;
    private static final DBQueryStageCompiler compiler = new DBQueryStageCompiler();

    public DBQueryStage(GraphRDB graph, SpecializedGraph sg, List varList, List dbPat, ExpressionSet constraints) {
        this.graph = graph;
        this.compiled = this.compile(sg, varList, dbPat, constraints);
    }

    protected DBQuery compile(SpecializedGraph sg, List varList, List dbPat, ExpressionSet constraints) {
        return this.compile(compiler, sg, varList, dbPat, constraints);
    }

    protected DBQuery compile(DBQueryStageCompiler compiler, SpecializedGraph sg, List varList, List dbPat, ExpressionSet constraints) {
        return DBQueryStageCompiler.compile(compiler, (DBQueryHandler)this.graph.queryHandler(), sg, varList, dbPat, constraints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run(Pipe source, Pipe sink) {
        block25: {
            Statement ps = null;
            ResultSet rs = null;
            try {
                if (!this.compiled.isEmpty) {
                    try {
                        IDBConnection conn = this.compiled.driver.getConnection();
                        ps = conn.getConnection().prepareStatement(this.compiled.stmt);
                    }
                    catch (Exception e) {
                        throw new JenaException("Query prepare failed: " + e);
                    }
                }
                if (ps == null) break block25;
                while (source.hasNext()) {
                    Domain current = source.get();
                    this.setArgs(current, (PreparedStatement)ps);
                    ResultSetIterator it = null;
                    try {
                        it = new ResultSetIterator();
                        ps.execute();
                        rs = ps.getResultSet();
                        it.reset(rs, (PreparedStatement)ps);
                        while (it.hasNext()) {
                            Domain useme = current.copy();
                            List row = (List)it.next();
                            for (int i = 0; i < this.compiled.resList.length; ++i) {
                                int j = this.compiled.resList[i];
                                String o = (String)row.get(i);
                                Node n = this.compiled.driver.RDBStringToNode(o);
                                useme.setElement(j, n);
                            }
                            sink.put(useme);
                        }
                    }
                    catch (Exception e) {
                        throw new JenaException("Query execute failed: " + e);
                    }
                    finally {
                        if (it == null) continue;
                        it.close();
                    }
                }
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e1) {
                        throw new RDFRDBException("Failed to get last inserted ID: " + e1);
                    }
                }
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (Exception e) {
                        throw new JenaException("Close on prepared stmt failed: " + e);
                    }
                }
                if (sink != null) {
                    sink.close();
                }
            }
        }
    }

    protected void setArgs(Domain args, PreparedStatement ps) {
        try {
            for (int i = 0; i < this.compiled.argCnt; ++i) {
                int ix = (Integer)this.compiled.argIndex.get(i);
                Node arg = (Node)args.get(ix);
                if (arg == null) {
                    throw new JenaException("Null query argument");
                }
                String val = this.compiled.driver.nodeToRDBString(arg, false);
                ps.setString(i + 1, val);
            }
        }
        catch (SQLException e) {
            throw new JenaException("Bad query argument", e);
        }
    }

    public Pipe deliver(final Pipe result) {
        final Pipe stream = this.previous.deliver(new BufferPipe());
        new Thread(){

            public void run() {
                DBQueryStage.this.run(stream, result);
            }
        }.start();
        return result;
    }
}

