/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.metaAnalysis;

import dr.inference.distribution.EmpiricalDistributionData;
import dr.inference.distribution.EmpiricalDistributionLikelihood;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import org.ohdsi.metaAnalysis.DataModel;

public class ParametricDataModel
extends DataModel.Base
implements DataModel {
    public ParametricDataModel(String string) {
        this();
        File file = new File(string);
        ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
        try {
            Scanner scanner = new Scanner(file);
            while (scanner.hasNext()) {
                String string2 = scanner.next();
                string2 = string2.replaceAll("\"", "");
                String[] stringArray = string2.split(",");
                arrayList.add(Arrays.asList(stringArray));
            }
            scanner.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        int n = ((List)arrayList.get(0)).indexOf("mu");
        int n2 = ((List)arrayList.get(0)).indexOf("sigma");
        int n3 = ((List)arrayList.get(0)).indexOf("gamma");
        for (int i = 1; i < arrayList.size(); ++i) {
            double[] dArray = new double[]{Double.parseDouble((String)((List)arrayList.get(i)).get(n)), Double.parseDouble((String)((List)arrayList.get(i)).get(n2)), Double.parseDouble((String)((List)arrayList.get(i)).get(n3))};
            this.addLikelihoodParameters(dArray, null);
        }
        this.finish();
    }

    public ParametricDataModel() {
    }

    @Override
    EmpiricalDistributionLikelihood makeFunctionalForm(List<EmpiricalDistributionData> list) {
        return new EmpiricalDistributionLikelihood(list, false){
            private static final long serialVersionUID = 5902404628932924630L;

            private final double sqr(double d) {
                return d * d;
            }

            protected double logPDF(double d, EmpiricalDistributionData empiricalDistributionData) {
                double d2 = empiricalDistributionData.values[0];
                double d3 = empiricalDistributionData.values[1];
                double d4 = empiricalDistributionData.values[2];
                return Math.exp(d4 * (d - d2)) * (-this.sqr(d - d2) / (2.0 * this.sqr(d3)));
            }

            protected double gradientLogPdf(double d, EmpiricalDistributionData empiricalDistributionData) {
                double d2 = empiricalDistributionData.values[0];
                double d3 = empiricalDistributionData.values[1];
                double d4 = empiricalDistributionData.values[2];
                return -(Math.exp(d4 * (d - d2)) * (d4 * (d - d2) + 2.0) * (d - d2)) / (2.0 * this.sqr(d3));
            }
        };
    }
}

