/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators;

public class OperatorUtils {
    public static double optimizeWindowSize(double d, double d2, double d3) {
        return OperatorUtils.optimizeWindowSize(d, Double.MAX_VALUE, d2, d3);
    }

    public static double optimizeWindowSize(double d, double d2, double d3, double d4) {
        double d5;
        if (d <= 0.0) {
            throw new IllegalArgumentException("random walk window size cannot be negative: " + d);
        }
        double d6 = d3 / d4;
        if (d6 > 2.0) {
            d6 = 2.0;
        }
        if (d6 < 0.5) {
            d6 = 0.5;
        }
        if ((d5 = d * d6) > d2) {
            d5 = d2;
        }
        return d5;
    }

    public static double optimizeScaleFactor(double d, double d2, double d3) {
        if (d <= 0.0 || d >= 1.0) {
            throw new IllegalArgumentException("scale factor was " + d + "!");
        }
        double d4 = d2 / d3;
        if (d4 > 2.0) {
            d4 = 2.0;
        }
        if (d4 < 0.5) {
            d4 = 0.5;
        }
        return Math.pow(d, d4);
    }
}

