/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.alloppnet.speciation;

import dr.evolution.tree.Tree;
import dr.evolution.util.Taxon;
import dr.evolution.util.Units;
import dr.evomodel.speciation.SpeciationModel;
import dr.inference.model.Parameter;
import dr.util.Author;
import dr.util.Citable;
import dr.util.Citation;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

public class BirthDeathCollapseModel
extends SpeciationModel
implements Citable {
    private Parameter birthDiffRate;
    private Parameter relativeDeathRate;
    private Parameter originHeight;
    private Parameter collapseWeight;
    private final double collapseHeight;

    public BirthDeathCollapseModel(String string, Tree tree, Units.Type type, Parameter parameter, Parameter parameter2, Parameter parameter3, Parameter parameter4, double d) {
        super(string, type);
        this.collapseHeight = d;
        this.birthDiffRate = parameter;
        this.addVariable(parameter);
        parameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.relativeDeathRate = parameter2;
        this.addVariable(parameter2);
        parameter2.addBounds(new Parameter.DefaultBounds(1.0, 0.0, 1));
        this.originHeight = parameter3;
        parameter3.setParameterValue(0, 1.05 * tree.getNodeHeight(tree.getRoot()));
        this.addVariable(parameter3);
        parameter3.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.collapseWeight = parameter4;
        this.addVariable(parameter4);
        parameter4.addBounds(new Parameter.DefaultBounds(1.0, 0.0, 1));
        Logger.getLogger("dr.evomodel.speciation").info("\tConstructing a birth-death-collapse model, please cite:\n" + Citable.Utils.getCitationString(this));
    }

    public double getCollapseHeight() {
        return this.collapseHeight;
    }

    public static boolean belowCollapseHeight(double d, double d2) {
        return d < d2;
    }

    @Override
    public double calculateTreeLogLikelihood(Tree tree) {
        double d = 0.0;
        int n = tree.getInternalNodeCount();
        int n2 = tree.getExternalNodeCount();
        double d2 = this.birthDiffRate.getParameterValue(0);
        double d3 = this.relativeDeathRate.getParameterValue(0);
        double d4 = this.originHeight.getParameterValue(0);
        double d5 = this.collapseWeight.getParameterValue(0);
        double d6 = tree.getNodeHeight(tree.getRoot());
        if (d6 > d4) {
            return Double.NEGATIVE_INFINITY;
        }
        d += this.originHeightLogLikelihood(d4, d2, d3, d5, n2);
        for (int i = 0; i < n; ++i) {
            double d7 = tree.getNodeHeight(tree.getInternalNode(i));
            double d8 = this.nodeHeightLikelihood(d7, d4, d2, d3);
            double d9 = d7 < this.collapseHeight ? 1.0 / this.collapseHeight : 0.0;
            d += Math.log((1.0 - d5) * d8 + d5 * d9);
        }
        return d;
    }

    private double originHeightLogLikelihood(double d, double d2, double d3, double d4, int n) {
        double d5 = Math.exp(-d2 * d);
        double d6 = (1.0 - d5) / (1.0 - d3 * d5);
        double d7 = 0.0;
        d7 += Math.log(d2);
        d7 += Math.log(1.0 - d3);
        d7 -= d2 * d;
        d7 -= 2.0 * Math.log(1.0 - d3 * d5);
        d7 += (double)(n - 2) * Math.log(d4 + (1.0 - d4) * d6);
        return d7 += Math.log(d4 + (double)n * (1.0 - d4) * d6);
    }

    private double nodeHeightLikelihood(double d, double d2, double d3, double d4) {
        double d5 = Math.exp(-d3 * d);
        double d6 = Math.exp(-d3 * d2);
        double d7 = 0.0;
        if (d < d2) {
            d7 = d3;
            d7 *= 1.0 - d4;
            d7 *= d5;
            d7 /= (1.0 - d4 * d5) * (1.0 - d4 * d5);
            d7 *= 1.0 - d4 * d6;
            d7 /= 1.0 - d6;
        }
        return d7;
    }

    @Override
    public double calculateTreeLogLikelihood(Tree tree, Set<Taxon> set) {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.SPECIES_MODELS;
    }

    @Override
    public String getDescription() {
        return "DISSECT species delimitation model";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(new Citation(new Author[]{new Author("Graham", "Jones"), new Author("Bengt", "Oxelman")}, "DISSECT: an assignment-free Bayesian discovery method for species delimitation under the multispecies coalescent", 2014, "BIORXIV/2014/003178", -1, -1, -1, Citation.Status.IN_SUBMISSION));
    }
}

